% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rcage.R
\name{plot.rcage}
\alias{plot.rcage}
\title{Generate Plots Summarizing Main Results}
\usage{
\method{plot}{rcage}(x, ..., dB, dataScale = NULL, palette = "plasma")
}
\arguments{
\item{x}{An rcage object. The value returned by optRegion() or region().}

\item{...}{ignored.}

\item{dB}{A SpatialPolygons object or SpatialPoints object. The areal
units of the finest resolution.}

\item{dataScale}{A function or NULL. If not NULL, the function to be 
applied to the outcome interest to adjust the scaling in plots.}

\item{palette}{A character. The palette preference for plotting. The 
palette is assumed to be viridis palette with possible values
'viridis', 'magma', 'plasma', 'inferno', 'cividis'}
}
\value{
No value object returned; called to generate plots.
}
\description{
Function generates plots showing the finest resolution, the support-level
 predictions, the support-level root prediction error, and the support-level
 CAGE/DCAGE.
}
\examples{

# create 5x5 square 

poly <- raster::rasterToPolygons(raster::raster(nrows = 5, ncols = 5,
                                                xmn = -1.25, xmx = 1.25,
                                                ymn = -1.25, ymx = 1.25,
                                                res = 0.5,
                                                crs = "+proj=longlat +datum=WGS84"))

df <- data.frame("x" = stats::rnorm(n = 25))

dt <- sp::SpatialPolygonsDataFrame(poly, df)

knots <- cbind(c(-0.75, 0.0, 0.75, -0.75, 0.0, 0.75, -0.75, 0.0, 0.75),
               c(-0.75,-0.75, -0.75, 0.0, 0.0, 0.0, 0.75, 0.75, 0.75))

res <- optRegion(spatialData = dt,
                 response = "x",
                 sigmavar = rep(1, 25),
                 gL = 5,
                 gU = 7,
                 nGibbs = 50L,
                 nBurn = 10L,
                 nThin = 1L,
                 nw = 2000L,
                 knots = knots)

 plot(x = res, dB = dt)
}
