% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_thresholding.R
\name{regional_thresholding}
\alias{regional_thresholding}
\title{Regional thresholding}
\usage{
regional_thresholding(
  r,
  segmentation,
  method,
  intercept = NULL,
  slope = NULL,
  prob = NULL
)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically,
the blue channel extracted from a canopy photograph. Please see
\code{\link{read_caim}} and \code{\link{normalize}}.}

\item{segmentation}{\linkS4class{SpatRaster}. The result of segmenting
\code{r}. Probably, \code{\link{rings_segmentation}} will be the most used
for fisheye images.}

\item{method}{Character vector of length one. See details for current
options.}

\item{intercept, slope}{Numeric vector of length one. These are linear
function coefficients--see section Details in \code{\link{thr_image}}.}

\item{prob}{Numeric vector of length one. Probability for
\code{\link[stats]{quantile}} calculation.}
}
\value{
An object of class \linkS4class{SpatRaster} with values \code{0} and
  \code{1}.
}
\description{
Regional thresholding of greyscale images.
}
\details{
Methods currently implemented are:

\itemize{

\item \strong{Diaz2018}: method presented in
\insertCite{Diaz2018;textual}{rcaiman} applied regionally. If this method is
selected, the arguments \code{intercept}, \code{slope}, and \code{prob}
should be provided. It works segment-wise extracting the digital numbers
(dns) per segment and passing them to \code{quantile(dns, prob)}, which
aggregated result (\code{x}) is in turn passed to \code{thr_image(x,
intercept, slope)}. Finally, this threshold image is applied to obtain a
binarized image.

\item \strong{Methods from autothresholdr package}: this function can call
methods from \code{\link[autothresholdr]{auto_thresh}}. Use \code{"IsoData"}
to use the algorithm by \insertCite{isodata;textual}{rcaiman}, which was
recommended by \insertCite{Jonckheere2005;textual}{rcaiman}.

\item \strong{Method isodata from this package}: Use \code{"thr_isodata"} to
use \code{\link{thr_isodata}}.

}
}
\examples{
\dontrun{
path <- system.file("external/DSCN4500.JPG", package = "rcaiman")
r <- read_caim(path, c(1280, 960) - 745, 745 * 2, 745 * 2)
blue <- gbc(r$Blue)
z <- zenith_image(ncol(r), lens("Nikon_FCE9"))
rings <- rings_segmentation(z, 10)
bin <- regional_thresholding(blue, rings, "Diaz2018", -8, 0.5, 1)
plot(bin)
bin <- regional_thresholding(blue, rings, "thr_isodata")
plot(bin)
}
}
\references{
\insertAllCited{}
}
\seealso{
Other Binarization Functions: 
\code{\link{apply_thr}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{obia}()},
\code{\link{ootb_mblt}()},
\code{\link{ootb_obia}()},
\code{\link{thr_image}()},
\code{\link{thr_isodata}()}
}
\concept{Binarization Functions}
