% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_sky_points.R
\name{extract_sky_points}
\alias{extract_sky_points}
\title{Extract sky points}
\usage{
extract_sky_points(r, bin, g, dist_to_plant = 3, min_raster_dist = 3)
}
\arguments{
\item{r}{\linkS4class{SpatRaster}. A normalized greyscale image. Typically, the
blue channel extracted from a canopy photograph. Please see \code{\link[=read_caim]{read_caim()}}
and \code{\link[=normalize]{normalize()}}.}

\item{bin}{\linkS4class{SpatRaster}. This should be a preliminary binarization of
\code{r} useful for masking pixels that are very likely pure sky pixels.}

\item{g}{\linkS4class{SpatRaster} built with \code{\link[=sky_grid_segmentation]{sky_grid_segmentation()}} or
\code{\link[=chessboard]{chessboard()}}.}

\item{dist_to_plant, min_raster_dist}{Numeric vector of length one or \code{NULL}.}
}
\value{
An object of the class \emph{data.frame} with two columns named
\emph{row} and \emph{col}.
}
\description{
Extract sky points for model fitting
}
\details{
This function will automatically sample sky pixels from the sky regions
delimited by \code{bin}. The density and distribution of the sampling points is
controlled by the arguments \code{g}, \code{dist_to_plant}, and \code{min_raster_dist}.

As the first step, sky pixels from \code{r} are evaluated to find the pixel with
maximum digital value (local maximum) per cell of the \code{g} argument. The
\code{dist_to_plant} argument allows users to establish a buffer zone for \code{bin},
meaning a size reduction of the original sky regions.

The final step is filtering these local maximum values by evaluating the
Euclidean distances between them on the raster space. Any new point with a
distance from existing points minor than \code{min_raster_dist} is discarded. Cell
labels determine the order in which the points are evaluated.

To skip a given filtering step, use code \code{NULL} as argument input. For
instance, \code{min_raster_dist = NULL} will return points omitting
the final step.
}
\examples{
\dontrun{
caim <- read_caim()
r <- caim$Blue
caim <- normalize(caim, 0, 20847, TRUE)
z <- zenith_image(ncol(caim), lens())
a <- azimuth_image(z)
plotRGB(caim*255)
bin <- ootb_obia(caim, z, a, HSV(239, 0.85, 0.5), gamma = NULL)
g <- sky_grid_segmentation(z, a, 10)
sky_points <- extract_sky_points(r, bin, g,
                                 dist_to_plant = 3,
                                 min_raster_dist = 10)
plot(bin)
points(sky_points$col, nrow(caim) - sky_points$row, col = 2, pch = 10)
}
}
\seealso{
\code{\link[=fit_cie_sky_model]{fit_cie_sky_model()}}

Other Tool Functions: 
\code{\link{colorfulness}()},
\code{\link{correct_vignetting}()},
\code{\link{defuzzify}()},
\code{\link{extract_dn}()},
\code{\link{extract_feature}()},
\code{\link{extract_rl}()},
\code{\link{extract_sky_points_simple}()},
\code{\link{extract_sun_coord}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{masking}()},
\code{\link{optim_normalize}()},
\code{\link{percentage_of_clipped_highlights}()},
\code{\link{read_bin}()},
\code{\link{read_caim_raw}()},
\code{\link{read_caim}()},
\code{\link{write_bin}()},
\code{\link{write_caim}()}
}
\concept{Tool Functions}
