% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{subset.CalDates}
\alias{subset.CalDates}
\title{Subsetting calibrated dates}
\usage{
\method{subset}{CalDates}(x, s, p, ...)
}
\arguments{
\item{x}{A CalDates class object}

\item{s}{Logical expression indicating dates to keep. The expression should include the term \code{BP} which refers to specific dates.}

\item{p}{Probability mass meeting the condition defined by \code{ss}.}

\item{...}{Further arguments to be passed to or from other methods (ignored).}
}
\value{
A CalDates class object.
}
\description{
Subsets calibrated dates (\code{CalDates} class object) based on Logical expressions of time intervals.
}
\details{
The function subsets \code{CalDates} class objects by identifying all dates that have a probability mass larger than \code{p} for a user defined logical expression of temporal interval containing the term \code{BP}, where \code{BP} refers to radiocarbon date. See examples for further detailes
}
\examples{
## Generate some calibrated dates
x = calibrate(c(12100,5410,5320,3320),errors=c(20,20,30,30))
## Subsets all dates that have a probability mass above 0.8 before 10000 BP
x2 = subset(x,BP>10000,p=0.8)
## Subsets all dates that have a probability mass above 0.5 between 6000 and 6300 BP
x3 = subset(x,BP>6000&BP<6300,p=0.5)
}
