/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import javax.vecmath.Vector3d;
import org.jmol.api.JmolAdapter;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.ChemFile;
import org.openscience.cdk.config.AtomTypeFactory;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.geometry.CrystalGeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemFile;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IChemSequence;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.ReaderFactory;
import org.openscience.cdk.tools.manipulator.ChemFileManipulator;
import org.openscience.cdk.tools.manipulator.ChemModelManipulator;
import org.openscience.cdk.tools.manipulator.SetOfMoleculesManipulator;

public class CdkJmolAdapter
extends JmolAdapter {
    public static final String ATOM_SET_INDEX = "org.jmol.adapter.cdk.ATOM_SET_INDEX";

    public CdkJmolAdapter(JmolAdapter.Logger logger) {
        super("CdkJmolAdapter", logger);
    }

    public Object openBufferedReader(String name, BufferedReader bufferedReader) {
        IChemFile chemFile;
        try {
            IChemObjectReader chemObjectReader;
            try {
                chemObjectReader = new ReaderFactory().createReader((Reader)bufferedReader);
            }
            catch (IOException ex) {
                return "Jmol: Error determining input format: " + ex;
            }
            if (chemObjectReader == null) {
                return "Jmol: unrecognized input format";
            }
            chemFile = (IChemFile)chemObjectReader.read((IChemObject)new ChemFile());
        }
        catch (CDKException ex) {
            return "Error reading input:" + (Object)((Object)ex);
        }
        if (chemFile == null) {
            return "unknown error reading file";
        }
        try {
            IAtom[] atoms;
            AtomTypeFactory factory = AtomTypeFactory.getInstance((String)"jmol_atomtypes.txt", (IChemObjectBuilder)chemFile.getBuilder());
            IAtomContainer atomContainer = ChemFileManipulator.getAllInOneContainer((IChemFile)chemFile);
            for (IAtom atom : atoms = atomContainer.getAtoms()) {
                try {
                    factory.configure(atom);
                }
                catch (CDKException exception) {
                    System.out.println("Could not configure atom: " + atom);
                }
            }
        }
        catch (ClassNotFoundException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        catch (IOException exception) {
            System.err.println(exception.toString());
            exception.printStackTrace();
        }
        return chemFile;
    }

    public String getFileTypeName(Object clientFile) {
        IAtomContainer atomContainer = this.getAtomContainer(clientFile);
        if (atomContainer != null && atomContainer.getAtomCount() > 0 && atomContainer.getAtom(0).getProperty((Object)"pdb.record") != null) {
            return "pdb";
        }
        return "other";
    }

    public String getAtomSetCollectionName(Object clientFile) {
        Object title;
        if (clientFile instanceof IChemObject && (title = ((IChemObject)clientFile).getProperty((Object)"Title")) != null) {
            System.out.println("Setting model name to title");
            return title.toString();
        }
        return null;
    }

    public int getAtomSetCount(Object clientFile) {
        if (clientFile instanceof IAtomContainer) {
            return 1;
        }
        if (clientFile instanceof IChemFile) {
            IChemFile chemFile = (IChemFile)clientFile;
            IChemSequence chemSequence = chemFile.getChemSequence(0);
            if (chemSequence != null) {
                return chemSequence.getChemModelCount();
            }
            return super.getAtomSetCount(clientFile);
        }
        return 0;
    }

    private IAtomContainer getAtomContainer(Object clientFile) {
        if (clientFile instanceof IAtomContainer) {
            return (IAtomContainer)clientFile;
        }
        if (clientFile instanceof IChemFile) {
            IChemFile chemFile = (IChemFile)clientFile;
            IChemSequence chemSequence = chemFile.getChemSequence(0);
            IChemModel[] chemModels = chemSequence.getChemModels();
            AtomContainer superMolecule = new AtomContainer();
            for (int i = 0; i < chemModels.length; ++i) {
                IChemModel chemModel = chemModels[i];
                ChemModelManipulator.setAtomProperties((IChemModel)chemModel, (Object)ATOM_SET_INDEX, (Object)i);
                IMoleculeSet setOfMolecules = chemModel.getSetOfMolecules();
                ICrystal crystal = chemModel.getCrystal();
                if (setOfMolecules != null) {
                    superMolecule.add(SetOfMoleculesManipulator.getAllInOneContainer((IMoleculeSet)setOfMolecules));
                    continue;
                }
                if (crystal != null) {
                    CrystalGeometryTools.fractionalToCartesian((ICrystal)crystal);
                    superMolecule.add((IAtomContainer)crystal);
                    continue;
                }
                System.out.println("Cannot display data in model");
                return null;
            }
            return superMolecule;
        }
        System.out.println("Cannot display data in model: clientFile must be instance of AtomContainer or ChemFile");
        return null;
    }

    public int getEstimatedAtomCount(Object clientFile) {
        return this.getAtomContainer(clientFile).getAtomCount();
    }

    public float[] getNotionalUnitcell(Object clientFile) {
        if (clientFile instanceof ICrystal) {
            ICrystal crystal = (ICrystal)clientFile;
            double[] notional = CrystalGeometryTools.cartesianToNotional((Vector3d)crystal.getA(), (Vector3d)crystal.getB(), (Vector3d)crystal.getC());
            float[] fNotional = new float[6];
            for (int i = 0; i < 6; ++i) {
                fNotional[i] = (float)notional[i];
            }
            return fNotional;
        }
        return null;
    }

    public String getClientAtomStringProperty(Object clientAtom, String propertyName) {
        Object value = ((IAtom)clientAtom).getProperty((Object)propertyName);
        return value == null ? null : "" + value;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object clientFile) {
        return new AtomIterator(this.getAtomContainer(clientFile));
    }

    public JmolAdapter.BondIterator getBondIterator(Object clientFile) {
        return new BondIterator(this.getAtomContainer(clientFile));
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        IAtomContainer atomContainer;
        IBond[] bonds;
        int ibond;
        IBond bond;
        IAtom[] bondedAtoms;

        BondIterator(IAtomContainer atomContainer) {
            super((JmolAdapter)CdkJmolAdapter.this);
            this.atomContainer = atomContainer;
            this.bonds = atomContainer.getBonds();
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bonds.length) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            this.bondedAtoms = this.bond.getAtoms();
            return true;
        }

        public Object getAtomUniqueID1() {
            return this.bondedAtoms.length == 2 ? this.bondedAtoms[0] : null;
        }

        public Object getAtomUniqueID2() {
            return this.bondedAtoms.length == 2 ? this.bondedAtoms[1] : null;
        }

        public int getEncodedOrder() {
            return (int)this.bond.getOrder();
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        IAtomContainer atomContainer;
        int atomCount;
        int iatom;
        IAtom atom;

        AtomIterator(IAtomContainer atomContainer) {
            super((JmolAdapter)CdkJmolAdapter.this);
            this.atomContainer = atomContainer;
            this.atomCount = atomContainer.getAtomCount();
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atomContainer.getAtom(this.iatom++);
            return true;
        }

        public Object getUniqueID() {
            return this.atom;
        }

        public int getElementNumber() {
            return this.atom.getAtomicNumber();
        }

        public String getElementSymbol() {
            return this.atom.getSymbol();
        }

        public float getX() {
            return (float)this.atom.getPoint3d().x;
        }

        public float getY() {
            return (float)this.atom.getPoint3d().y;
        }

        public float getZ() {
            return (float)this.atom.getPoint3d().z;
        }

        public String getPdbAtomRecord() {
            return (String)this.atom.getProperty((Object)"pdb.record");
        }

        public String getAtomName() {
            return this.atom.getAtomTypeName();
        }

        public int getAtomSetIndex() {
            Integer indexInt = (Integer)this.atom.getProperty((Object)CdkJmolAdapter.ATOM_SET_INDEX);
            System.out.println("indexInt: " + indexInt);
            if (indexInt != null) {
                return indexInt;
            }
            return super.getAtomSetIndex();
        }

        public char getChainID() {
            String chainID = (String)this.atom.getProperty((Object)"pdb.chainID");
            if (chainID != null && chainID.length() > 0) {
                return chainID.charAt(0);
            }
            return super.getChainID();
        }

        public String getGroup3() {
            String resName = (String)this.atom.getProperty((Object)"pdb.resName");
            if (resName != null && resName.length() > 0) {
                return resName.trim();
            }
            return super.getGroup3();
        }

        public int getSequenceNumber() {
            String sequenceNumber = (String)this.atom.getProperty((Object)"pdb.resSeq");
            if (sequenceNumber != null && sequenceNumber.length() > 0) {
                try {
                    return Integer.parseInt(sequenceNumber);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return super.getSequenceNumber();
        }

        public char getInsertionCode() {
            String iCode = (String)this.atom.getProperty((Object)"pdb.iCode");
            if (iCode != null && iCode.length() > 0) {
                return iCode.charAt(0);
            }
            return super.getInsertionCode();
        }

        public Object getClientAtomReference() {
            return this.atom;
        }
    }
}

