% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/props.R
\name{set.property}
\alias{set.property}
\title{Set a property value of the molecule.}
\usage{
set.property(molecule, key, value)
}
\arguments{
\item{molecule}{The molecule to query. Should be a `jobjRef` representing an `IAtomContainer`}

\item{key}{The property key as a character string}

\item{value}{The value of the property. This can be a character, numeric or 
`jobjRef` R object}
}
\description{
This function sets the value of a keyed property on the molecule. 
Properties enable us to associate arbitrary pieces of data with a 
molecule. Such data can be text, numeric or a Java object 
(represented as a `jobjRef`).
}
\examples{
mol <- parse.smiles("CC1CC(C=O)CCC1")[[1]]
set.property(mol, 'prop1', 23.45)
set.property(mol, 'prop2', 'inactive')
get.property(mol, 'prop1')

}
\seealso{
\code{\link{get.property}}, \code{\link{get.properties}}, \code{\link{remove.property}}
}
\author{
Rajarshi Guha (\email{rajarshi.guha@gmail.com})
}
