/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import org.jaxen.Context;
import org.jaxen.UnresolvableException;
import org.jaxen.expr.DefaultExpr;
import org.jaxen.expr.VariableReferenceExpr;
import org.jaxen.expr.Visitor;

class DefaultVariableReferenceExpr
extends DefaultExpr
implements VariableReferenceExpr {
    private String prefix;
    private String localName;

    DefaultVariableReferenceExpr(String prefix, String variableName) {
        this.prefix = prefix;
        this.localName = variableName;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getVariableName() {
        return this.localName;
    }

    public String toString() {
        if (this.prefix == null) {
            return "[(DefaultVariableReferenceExpr): " + this.localName + "]";
        }
        return "[(DefaultVariableReferenceExpr): " + this.prefix + ":" + this.localName + "]";
    }

    public String getText() {
        if (this.prefix == null) {
            return "$" + this.localName;
        }
        return "$" + this.prefix + ":" + this.localName;
    }

    public Object evaluate(Context context) throws UnresolvableException {
        String namespaceURI = context.translateNamespacePrefixToUri(this.getPrefix());
        return context.getVariableValue(namespaceURI, this.prefix, this.localName);
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }
}

