% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cp_children.R
\name{cp_children}
\alias{cp_children}
\title{Children}
\usage{
cp_children(dataset_key, taxon_id, ...)
}
\arguments{
\item{dataset_key}{(character/integer/numeric) dataset identifier}

\item{taxon_id}{(character/integer/numeric) taxon identifier}

\item{...}{curl options passed on to \link[crul:verb-GET]{crul::verb-GET}}
}
\value{
list with two slots
\itemize{
\item \code{result} (data.frame/tibble): results, a zero row data.frame
if no results found
\item \code{meta} (data.frame/tibble): number of results found
}
}
\description{
Children
}
\examples{
chk <- function(x) {
  z <- tryCatch(crul::ok(x), error = function(e) e)
  if (inherits(z, "error")) FALSE else z
}
if (chk("https://api.catalogueoflife.org/version")) {
z <- cp_children(dataset_key=1000, taxon_id='1')
z
z$result
if (NROW(z$result) > 0) {
z$result$scientificName
z$result$created
}
}
}
