% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotNormalDensity.r
\name{plotNormalDensity}
\alias{plotNormalDensity}
\title{Density plot with a normal curve}
\usage{
plotNormalDensity(x, col1 = "white", col2 = "gray", col3 = "blue",
  border = NA, main = "", lwd = 2, length = 1000, adjust = 1,
  bw = "nrd0", kernel = "gaussian", ...)
}
\arguments{
\item{x}{A vector of values.}

\item{col1}{The color of the density plot. Usually not visible.}

\item{col2}{The color of the density polygon.}

\item{col3}{The color of the normal line.}

\item{border}{The color of the border around the density polygon.}

\item{main}{The title displayed for the plot.}

\item{lwd}{The width of the line in the plot.}

\item{length}{The number of points in the line in the plot.}

\item{adjust}{Passed to  \code{\link{density}}. 
A lower value makes the density plot smoother.}

\item{bw}{Passed to  \code{\link{density}}.}

\item{kernel}{Passed to  \code{\link{density}}.}

\item{...}{Other arguments passed to \code{\link{plot}}.}
}
\value{
Produces a plot. Returns nothing.
}
\description{
Produces a density plot for a vector of values and adds 
             a normal curve with the same mean and standard deviation. The 
             plot can be used to quickly compare the distribution of data
             to a normal distribution.
}
\details{
The function plots a polygon based on the \code{density} function. 
          The normal curve has the same mean and standard deviation as the 
          values in the vector.
}
\examples{
### Plot of residuals from a model fit with lm
data(Catbus)
model = lm(Steps ~ Sex + Teacher,
           data = Catbus)
 plotNormalDensity(residuals(model))          

}
\references{
\url{http://rcompanion.org/handbook/I_01.html}
}
\seealso{
\code{\link{plotNormalHistogram}} \code{\link{plotDensityHistogram}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{normal distribution density}
