% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cliffDelta.r
\name{cliffDelta}
\alias{cliffDelta}
\title{Cliff's delta}
\usage{
cliffDelta(formula = NULL, data = NULL, x = NULL, y = NULL,
  ci = FALSE, conf = 0.95, type = "perc", R = 1000,
  histogram = FALSE, digits = 3, ...)
}
\arguments{
\item{formula}{A formula indicating the response variable and
the independent variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{If no formula is given, the response variable for one group.}

\item{y}{The response variable for the other group.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{digits}{The number of significant digits in the output.}

\item{...}{Additional arguments passed to the \code{wilcox.test} function.}
}
\value{
A single statistic, Cliff's delta.
        Or a small data frame consisting of Cliff's delta,
        and the lower and upper confidence limits.
}
\description{
Calculates Cliff's delta
             with confidence intervals by bootstrap
}
\details{
Cliff's delta is an effect size statistic appropriate
         in cases where a Wilcoxon-Mann-Whitney test might be used.
         It ranges from -1 to 1, with 0 indicating stochastic equality,
         and 1 indicating that the first group dominates the second.
         It is linearly related to Vargha and Delaney's A.
          
         The function calculates Cliff's delta from the "W" 
         U statistic from the
         \code{wilcox.test} function.
         Specifically, \code{VDA = U/(n1*n2); CD = (VDA-0.5)*2}.
           
         The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{y}. If there are more than two groups,
         only the first two groups are used.
         
          Currently, the function makes no provisions for \code{NA}
          values in the data.  It is recommended that \code{NA}s be removed
          beforehand.
          
          When the data in the first group are greater than
          in the second group, Cliff's delta is positive.
          When the data in the second group are greater than
          in the first group, Cliff's delta is negative.
          Be cautious with this interpretation, as R will alphabetize
          groups in the formula interface if the grouping variable
          is not already a factor.

          When Cliff's delta is close to 1 or close to -1,
          or with small sample size,
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(Catbus)
cliffDelta(Steps ~ Sex, data=Catbus)

}
\references{
\url{http://rcompanion.org/handbook/F_04.html}
}
\seealso{
\code{\link{vda}}, \code{\link{multiVDA}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{effect size}
