% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwiseMedianMatrix.r
\name{pairwiseMedianMatrix}
\alias{pairwiseMedianMatrix}
\title{Pairwise Mood's median tests with matrix output}
\usage{
pairwiseMedianMatrix(
  formula = NULL,
  data = NULL,
  x = NULL,
  g = NULL,
  digits = 4,
  method = "fdr",
  ...
)
}
\arguments{
\item{formula}{A formula indicating the measurement variable and
the grouping variable. e.g. y ~ group.}

\item{data}{The data frame to use.}

\item{x}{The response variable as a vector.}

\item{g}{The grouping variable as a vector.}

\item{digits}{The number of significant digits to round output.}

\item{method}{The p-value adjustment method to use for multiple tests.
See \code{stats::p.adjust}.}

\item{...}{Additional arguments passed to
\code{coin::median_test}.}
}
\value{
A list consisting of:
        a matrix of p-values;
        the p-value adjustment method;
        a matrix of adjusted p-values.
}
\description{
Conducts pairwise Mood's median tests across groups.
}
\details{
The input should include either \code{formula} and \code{data};
         or \code{x}, and \code{g}.
         
         Mood's median test compares medians among two or more groups.
         See \url{http://rcompanion.org/handbook/F_09.html} for
         futher discussion of this test.

         The \code{pairwiseMedianMatrix} function
         can be used as a post-hoc method following an omnibus Mood's
         median test. It passes the data for pairwise groups to
         \code{coin::median_test}.
         
         The matrix output can be converted to a compact letter display,
         as in the example.
}
\note{
The parsing of the formula is simplistic. 
         The first variable on the
         left side is used as the measurement variable.  
         The first variable on the
         right side is used for the grouping variable.
}
\examples{
data(PoohPiglet)
PoohPiglet$Speaker = factor(PoohPiglet$Speaker,
                          levels = c("Pooh", "Tigger", "Piglet"))
PT = pairwiseMedianMatrix(Likert ~ Speaker,
                          data   = PoohPiglet,
                          exact  = NULL,
                          method = "fdr")$Adjusted
PT                           
library(multcompView)
multcompLetters(PT,
                compare="<",
                threshold=0.05,
                Letters=letters)                    

}
\references{
\url{http://rcompanion.org/handbook/F_09.html}
}
\seealso{
\code{\link{pairwiseMedianTest}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{moods median nonparametric post-hoc one-way cld}
