% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phi.r
\name{phi}
\alias{phi}
\title{phi}
\usage{
phi(
  x,
  y = NULL,
  ci = FALSE,
  conf = 0.95,
  type = "perc",
  R = 1000,
  histogram = FALSE,
  verbose = FALSE,
  digits = 3,
  reportIncomplete = FALSE,
  ...
)
}
\arguments{
\item{x}{Either a 2 x 2 table or a 2 x 2 matrix.
Can also be a vector of observations for one dimension
of a 2 x 2 table.}

\item{y}{If \code{x} is a vector, \code{y} is the vector of observations for
the second dimension of a 2 x2  table.}

\item{ci}{If \code{TRUE}, returns confidence intervals by bootstrap.
May be slow.}

\item{conf}{The level for the confidence interval.}

\item{type}{The type of confidence interval to use.
Can be any of "\code{norm}", "\code{basic}", 
              "\code{perc}", or "\code{bca}".
Passed to \code{boot.ci}.}

\item{R}{The number of replications to use for bootstrap.}

\item{histogram}{If \code{TRUE}, produces a histogram of bootstrapped values.}

\item{verbose}{If \code{TRUE}, prints the table of counts.}

\item{digits}{The number of significant digits in the output.}

\item{reportIncomplete}{If \code{FALSE} (the default),
\code{NA} will be reported in cases where there
are instances of the calculation of the statistic
failing during the bootstrap procedure.}

\item{...}{Additional arguments. (Ignored.)}
}
\value{
A single statistic, phi. 
        Or a small data frame consisting of phi,
        and the lower and upper confidence limits.
}
\description{
Calculates phi for a 2 x 2 table of nominal variables;
             confidence intervals by bootstrap.
}
\details{
phi is used as a measure of association
          between two binomial variables, or as an effect size
          for a chi-square test of association for a 2 x 2 table.
          The absolute value of the phi statistic is the same as
          Cramer's V for a 2 x 2 table.
          
          Unlike Cramer's V, phi can be positive or negative (or zero), and
          ranges from -1 to 1.
          
          When phi is close to its extremes,
          or with small counts, 
          the confidence intervals 
          determined by this
          method may not be reliable, or the procedure may fail.
}
\examples{
### Example with table
Matrix = matrix(c(13, 26, 26, 13), ncol=2)
phi(Matrix)

### Example with two vectors
Species = c(rep("Species1", 16), rep("Species2", 16))
Color   = c(rep(c("blue", "blue", "blue", "green"),4),
            rep(c("green", "green", "green", "blue"),4))
phi(Species, Color)

}
\references{
\url{https://rcompanion.org/handbook/H_10.html}
}
\seealso{
\code{\link{cramerV}}
}
\author{
Salvatore Mangiafico, \email{mangiafico@njaes.rutgers.edu}
}
\concept{Cramer's V}
\concept{chi square test}
\concept{confidence interval}
\concept{correlation}
\concept{effect size}
\concept{phi}
