% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_lifecycle_badge.R
\name{add_lifecycle_badge}
\alias{add_lifecycle_badge}
\title{Add a Life Cycle badge}
\usage{
add_lifecycle_badge(lifecycle = "experimental", quiet = FALSE)
}
\arguments{
\item{lifecycle}{A character of length 1. Accepted stages are:
\code{'experimental'} (default), \code{'stable'}, \code{'deprecated'}, or \code{'superseded'}.}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
A badge as a markdown expression.
}
\description{
This function adds or updates the \strong{Life Cycle} badge to the \code{README.Rmd}.
It is based on the standard defined at
\url{https://lifecycle.r-lib.org/articles/stages.html}.

Make sure that 1) a \code{README.Rmd} file exists at the project root and 2) it
contains a block starting with the line \verb{<!-- badges: start -->} and ending
with the line \verb{<!-- badges: end -->}.

Don't forget to re-render the \code{README.md}.
}
\details{
The project can have the following life cycle stage:
\itemize{
\item \strong{Experimental} - An experimental project is made available so user
can try it out and provide feedback, but come with no promises for long
term stability.
\item \strong{Stable} - A project is considered stable when the author is happy
with its interface, does not see major issues, and is happy to share it
with the world.
\item \strong{Superseded} - A superseded project has a known better
alternative, and it is not going away. Superseded project will not receive
new features, but will receive any critical bug fixes needed to keep it
working.
\item \strong{Deprecated} - A deprecated project has a better alternative
available and is scheduled for removal.
}
}
\examples{
\dontrun{
add_lifecycle_badge()
add_lifecycle_badge(lifecycle = "stable")
}
}
\seealso{
Other adding badges: 
\code{\link{add_codecov_badge}()},
\code{\link{add_cran_badge}()},
\code{\link{add_dependencies_badge}()},
\code{\link{add_github_actions_check_badge}()},
\code{\link{add_github_actions_codecov_badge}()},
\code{\link{add_github_actions_pkgdown_badge}()},
\code{\link{add_license_badge}()},
\code{\link{add_repostatus_badge}()}
}
\concept{adding badges}
