% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_license.R
\name{add_license}
\alias{add_license}
\title{Add a LICENSE}
\usage{
add_license(license = NULL, given = NULL, family = NULL, quiet = FALSE)
}
\arguments{
\item{license}{A character of length 1. The chosen license.
Run \code{\link[=get_licenses]{get_licenses()}}) to select an appropriate one.}

\item{given}{A character of length 1. The given name of the copyright holder.
Only required if \code{license = 'MIT'}. If is \code{NULL} (default) and
\code{license = 'MIT'}, this function will try to retrieve the value of this
parameter from the \code{.Rprofile} file (edited with \code{\link[=set_credentials]{set_credentials()}}).}

\item{family}{A character of length 1. The family name of the copyright
holder. Only required if \code{license = 'MIT'}. If is \code{NULL} (default) and
\code{license = 'MIT'}, this function will try to retrieve the value of this
parameter from the \code{.Rprofile} file (edited with \code{\link[=set_credentials]{set_credentials()}}).}

\item{quiet}{A logical value. If \code{TRUE} messages are deleted. Default is
\code{FALSE}.}
}
\value{
No return value.
}
\description{
This function adds a license to the project. It will add the license name
in the \code{License} field of the \code{DESCRIPTION} file and write the content of
the license in the \code{License.md} file.
}
\examples{
\dontrun{
add_license(license = "MIT")
add_license(license = "GPL (>= 2)")
}
}
\seealso{
Other create files: 
\code{\link{add_citation}()},
\code{\link{add_code_of_conduct}()},
\code{\link{add_compendium}()},
\code{\link{add_contributing}()},
\code{\link{add_description}()},
\code{\link{add_dockerfile}()},
\code{\link{add_makefile}()},
\code{\link{add_package_doc}()},
\code{\link{add_readme_rmd}()},
\code{\link{add_renv}()},
\code{\link{add_testthat}()},
\code{\link{add_vignette}()}
}
\concept{create files}
