% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_articles_search.R
\name{core_articles_search}
\alias{core_articles_search}
\alias{core_articles_search_}
\title{Search CORE articles}
\usage{
core_articles_search(query, metadata = TRUE, fulltext = FALSE,
  citations = FALSE, similar = FALSE, duplicate = FALSE,
  urls = FALSE, faithfulMetadata = FALSE, page = 1, limit = 10,
  key = NULL, parse = TRUE, ...)

core_articles_search_(query, metadata = TRUE, fulltext = FALSE,
  citations = FALSE, similar = FALSE, duplicate = FALSE,
  urls = FALSE, faithfulMetadata = FALSE, page = 1, limit = 10,
  key = NULL, ...)
}
\arguments{
\item{query}{(character) query string, required}

\item{metadata}{(logical) Whether to retrieve the full article metadata or
only the ID. Default: \code{TRUE}}

\item{fulltext}{(logical) Whether to retrieve full text of the article.
Default: \code{FALSE}}

\item{citations}{(logical) Whether to retrieve citations found in the
article. Default: \code{FALSE}}

\item{similar}{(logical) Whether to retrieve a list of similar articles.
Default: \code{FALSE}. Because the similar articles are calculated on demand,
setting this parameter to true might slightly slow down the response time}

\item{duplicate}{(logical) Whether to retrieve a list of CORE IDs of
different versions of the article. Default: \code{FALSE}}

\item{urls}{(logical) Whether to retrieve a list of URLs from which the
article can be downloaded. This can include links to PDFs as well as
HTML pages. Default: \code{FALSE}}

\item{faithfulMetadata}{(logical) Returns the records raw XML metadata
from the original repository. Default: \code{FALSE}}

\item{page}{(character) page number (default: 1), optional}

\item{limit}{(character) records to return (default: 10, minimum: 10),
optional}

\item{key}{A CORE API key. Get one at
\url{https://core.ac.uk/api-keys/register}. Once you have the key,
you can pass it into this parameter, or as a much better option,
store your key as an environment variable with the name
\code{CORE_KEY} or an R option as \code{core_key}. See \code{?Startup}
for how to work with env vars and R options}

\item{parse}{(logical) Whether to parse to list (\code{FALSE}) or
data.frame (\code{TRUE}). Default: \code{TRUE}}

\item{...}{Curl options passed to \code{\link[crul]{HttpClient}}}
}
\description{
Search CORE articles
}
\details{
\code{core_articles_search} does the HTTP request and parses, while
\code{core_articles_search_} just does the HTTP request, gives back JSON as a character
string
}
\examples{
\dontrun{
core_articles_search(query = 'ecology')
core_articles_search(query = 'ecology', parse = FALSE)
core_articles_search(query = 'ecology', limit = 12)
out = core_articles_search(query = 'ecology', fulltext = TRUE)

core_articles_search_(query = 'ecology')
jsonlite::fromJSON(core_articles_search_(query = 'ecology'))

# post request
query <- c('data mining', 'semantic web')
res <- core_articles_search(query)
head(res$data)
res$data[[2]]$doi
}
}
\references{
\url{https://core.ac.uk/docs/#!/all/search}
}
