% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CMBDat.R
\name{CMBDat}
\alias{CMBDat}
\title{CMBDat class}
\usage{
CMBDat(filename, mmap = FALSE, spix)
}
\arguments{
\item{filename}{The path to the fits file.}

\item{mmap}{A boolean indicating whether to use memory mapping.}

\item{spix}{The sample pixels (rows) to read from the FITS file
binary data table (optional)}
}
\value{
A list containing header information and other metadata
as well as an element called \code{data} where:
If \code{mmap = FALSE} then a \code{data.frame} is
included, named \code{data}, whose columns may include, for
example, the intensity (I), polarisation (Q, U), PMASK and TMASK.
If \code{mmap = TRUE} then a \code{\link{mmap}} object is returned
that points to the CMB map data table in the FITS file.
}
\description{
The function \code{CMBDat} creates objects of class \code{CMBDat}.
These are lists containing header information and other metadata as well
as an element called data, whose columns may include, for example, the
intensity (I), polarisation (Q, U), PMASK and TMASK. It also may contain an
\code{\link{mmap}} object that points to the CMB map data table in the FITS
file.
}
\examples{

## Ensure you have a FITS file with the correct path
## before running the example:
## download a FITS file and use real data
# downloadCMBMap()
# cmbdat <- CMBDat("CMB_map_smica1024.fits", mmap = TRUE)
# class(cmbdat)
# str(cmbdat)

## View metadata
# cmbdat$header1
# cmbdat$header2
# cmbdat$resoln
# cmbdat$method
# cmbdat$coordsys
# cmbdat$nside
# cmbdat$hdr

}
