% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NestSearch.R
\name{baseNeighbours}
\alias{baseNeighbours}
\title{Return neighbours of base pixels}
\usage{
baseNeighbours(bp)
}
\arguments{
\item{bp}{The base pixel index}
}
\description{
The base-resolution comprises twelve pixels. \code{baseNeighbours} returns
a map from the base pixel index bp to the vector of base pixels
that are neighbours of bp, in counterclockwise order of
direction: S,SE,E,NE,N,NW,W,SW. The presence of -1 indicates
that the corresponding direction is empty.
}
\examples{
## Return neighbours of base pixel 1
baseNeighbours(1)

## There is no base pixel 14, so baseNeighbours returns NULL
baseNeighbours(14)

}
