% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{plotAngDis}
\alias{plotAngDis}
\title{Plot angular scatterplots and means}
\usage{
plotAngDis(cmbdf, intensities = "I")
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}} object.}

\item{intensities}{The name of a column of \code{cmbdf},
containing measured values.}
}
\value{
2x2 plot. The first row shows scatterplots. The second row gives
barplots of the corresponding means computed over bins. The first column
corresponds to the values of theta  and the second one is for psi.
}
\description{
For specified measurements from \code{\link{CMBDataFrame}} this function
produces scatterplots and binned means versus theta and phi angles.
}
\examples{
## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# df.sample <- CMBDataFrame(df, sample.size = 80000)
# win <- CMBWindow(theta = c(pi/4,pi/2,pi/2,pi/4), phi = c(0,0,pi/2,pi/2))
# cmbdf.win <- window(df.sample, new.window = win)
#
# intensities <- "I"
# plotAngDis(cmbdf.win, intensities)

}
