% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statistics.R
\name{qqnormWin}
\alias{qqnormWin}
\title{Normal QQ plot for \code{\link{CMBWindow}}}
\usage{
qqnormWin(cmbdf, win, intensities = "I")
}
\arguments{
\item{cmbdf}{A \code{\link{CMBDataFrame}}.}

\item{win}{A \code{\link{CMBWindow}}}

\item{intensities}{A \code{\link{CMBDataFrame}} column with measured values.}
}
\value{
A list with quantile components x and y and a normal QQ plot with QQ line
}
\description{
This function is a modification of standard \link{qqnorm} functions to work
with \code{\link{CMBWindow}} regions.
}
\details{
\code{\link{qqnormWin}} returns a normal QQ plot of for the specified
\code{\link{CMBDataFrame}} column \code{intensities} and \code{\link{CMBWindow}}
region. The function automatically adds a line of a “theoretical” normal
quantile-quantile plot.
}
\examples{
## Download the map first
# downloadCMBMap(foreground = "smica", nside = 1024)
# df <- CMBDataFrame("CMB_map_smica1024.fits")
# cmbdf <- sampleCMB(df, sample.size = 1000)

# win1 <- CMBWindow(theta = c(0,pi/2,pi/2), phi = c(0,0,pi/2))
# qqnormWin(cmbdf, win1)

}
\references{
\link{qqnorm}, \link{qqplot}, \link{qqplotWin}
}
