% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleaning_functions.R
\name{clean_ballot}
\alias{clean_ballot}
\title{Master one-step cleaning function}
\usage{
clean_ballot(ballot, b_header, lookup, l_header, format)
}
\arguments{
\item{ballot}{The raw ballot image}

\item{b_header}{Whether the ballot image has a header line or not}

\item{lookup}{The raw lookup image}

\item{l_header}{Whether the lookup image has a header line or not}

\item{format}{A character string detailing the format. Current
supported formats are "WinEDS" and "ChoicePlus" (forthcoming), based on
common types of software used. Contact creators with suggestions for
more formats.}
}
\value{
The ballot data, but now "readable" so votes can be understood
}
\description{
Wraps `import_data`, `label`, and `characterize` to clean the ballot
image in one step.
}
\examples{
clean_ballot(ballot = sf_bos_ballot, b_header = TRUE,
lookup = sf_bos_lookup, l_header = TRUE, format = "WinEDS")
}
