% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wt_kern.R
\name{wt_kern}
\alias{wt_kern}
\title{Kernel Weight Calculation}
\usage{
wt_kern(X, center, bw, kernel = "triangular")
}
\arguments{
\item{X}{The input x values. This variable represents the axis along which kernel weighting 
should be performed.}

\item{center}{The point from which distances should be calculated.}

\item{bw}{The bandwidth.}

\item{kernel}{A string indicating the kernel to use. Options are \code{"triangular"} (the default), 
\code{"epanechnikov"}, \code{"quartic"}, \code{"triweight"}, \code{"tricube"}, \code{"gaussian"},
and \code{"cosine"}.}
}
\value{
A vector of weights with length equal to that of the \code{X} input 
  (one weight per element of \code{X}).
}
\description{
\code{wt_kern} calculates the appropriate kernel weights for a vector. 
This is useful when, for instance, one wishes to perform local regression.
It is based on the \code{\link[rdd]{kernelwts}} function in the \pkg{rdd} package.
}
