% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/variables.R
\name{ddi_derivation}
\alias{ddi_derivation}
\alias{ddi_drvdesc}
\alias{ddi_drvcmd}
\title{derivation and its child nodes}
\usage{
ddi_derivation(...)

ddi_drvdesc(...)

ddi_drvcmd(...)
}
\arguments{
\item{...}{Child nodes or attributes.}
}
\value{
A ddi_node object.
}
\description{
Used only in the case of a derived variable, this element provides both a
description of how the derivation was performed and the command used to
generate the derived variable, as well as a specification of the other
variables in the study used to generate the derivation. The "var" attribute
provides the ID values of the other variables in the study used to generate
this derived variable. More information on these elements, especially their
allowed attributes, can be found in the references.
}
\details{
\emph{Parent nodes}

\code{derivation} is included in \code{var}.

\emph{derivation specific child nodes}
\itemize{
\item \code{ddi_drvcmd()} is the actual command used to generate the derived variable.
The "syntax" attribute is used to indicate the command language employed
(e.g., SPSS, SAS, Fortran, etc.). The element may be repeated to support
multiple language expressions of the content.
\item \code{ddi_drvdesc()} is a textual description of the way in which this variable
was derived. The element may be repeated to support multiple language
expressions of the content.
}
}
\examples{
ddi_derivation()

# Functions that need to be wrapped in ddi_derivation()

ddi_drvcmd(syntax = "SPSS",
           "RECODE V1 TO V3 (0=1) (1=0) (2=-1) INTO DEFENSE WELFARE HEALTH.")

ddi_drvdesc("VAR215.01 'Outcome of first pregnancy' (1988 NSFG=VAR611 PREGOUT1) 
            If R has never been pregnant (VAR203 PREGNUM EQ 0) then OUTCOM01 is 
            blank/inapplicable. Else, OUTCOM01 is transferred from VAR225 
            OUTCOME for R's 1st pregnancy.")

}
\references{
\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/derivation.html}{derivation documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/drvcmd.html}{drvcmd documentation}

\href{https://ddialliance.org/Specification/DDI-Codebook/2.5/XMLSchema/field_level_documentation_files/schemas/codebook_xsd/elements/drvdesc.html}{drvdesc documentation}
}
