% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rdd_data.R
\name{rdd_data}
\alias{rdd_data}
\title{Construct rdd_data}
\usage{
rdd_data(y, x, covar, cutpoint, z, labels, data)
}
\arguments{
\item{y}{Output}

\item{x}{Forcing variable}

\item{covar}{Exogeneous variables}

\item{cutpoint}{Cutpoint}

\item{z}{Assignment variable for the fuzzy case.}

\item{labels}{Additional labels to provide as list (with entries \code{x}, \code{y}, and eventually vector \code{covar}). Unused currently.}

\item{data}{A data-frame for the \code{x} and \code{y} variables. If this is provided,
the column names can be entered directly for argument \code{x} and \code{y}}
}
\value{
Object of class \code{rdd_data}, inheriting from \code{data.frame}
}
\description{
Construct the base RDD object, containing x, y and the cutpoint, eventuallay covariates.
}
\examples{
data(house)
rd<- rdd_data(x=house$x, y=house$y, cutpoint=0)
rd2 <- rdd_data(x=x, y=y, data=house, cutpoint=0)

# The print() function is the same as the print.data.frame:
rd

# The summary() and plot() function are specific to rdd_data
summary(rd)
plot(rd)
}
\author{
Matthieu Stigler <\email{Matthieu.Stigler@gmail.com}>
}

