% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Node.R
\docType{class}
\name{Node}
\alias{Node}
\title{\verb{Node} class}
\description{
An R6 class to represent a node in a decision tree
}
\details{
Base class to represent a single node in a decision tree. Objects of base
class \code{Node} are not expected to be created as model objects.
}
\author{
Andrew Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Node$new()}}
\item \href{#method-label}{\code{Node$label()}}
\item \href{#method-type}{\code{Node$type()}}
\item \href{#method-clone}{\code{Node$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create new \code{Node} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$new(label = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{label}}{An optional label for the node.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Node} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-label"></a>}}
\if{latex}{\out{\hypertarget{method-label}{}}}
\subsection{Method \code{label()}}{
Return the label of the node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$label()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Label as a character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-type"></a>}}
\if{latex}{\out{\hypertarget{method-type}{}}}
\subsection{Method \code{type()}}{
node type
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$type()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{Node} class, as character string.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Node$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
