% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arrow.R
\docType{class}
\name{Arrow}
\alias{Arrow}
\title{A directed edge in a digraph}
\description{
An R6 class representing an directed edge in a digraph.
}
\details{
An arrow is the formal term for an edge between pairs of nodes in a
directed graph. Inherits from class \code{Edge}.
}
\author{
Andrew J. Sims \email{andrew.sims@newcastle.ac.uk}
}
\section{Super class}{
\code{\link[rdecision:Edge]{rdecision::Edge}} -> \code{Arrow}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Arrow$new()}}
\item \href{#method-source}{\code{Arrow$source()}}
\item \href{#method-target}{\code{Arrow$target()}}
\item \href{#method-clone}{\code{Arrow$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="endpoints">}\href{../../rdecision/html/Edge.html#method-endpoints}{\code{rdecision::Edge$endpoints()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="is_same_edge">}\href{../../rdecision/html/Edge.html#method-is_same_edge}{\code{rdecision::Edge$is_same_edge()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="rdecision" data-topic="Edge" data-id="label">}\href{../../rdecision/html/Edge.html#method-label}{\code{rdecision::Edge$label()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an object of type \code{Arrow}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arrow$new(source, target, label = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{source}}{Node from which the arrow leaves.}

\item{\code{target}}{Node to which the arrow points.}

\item{\code{label}}{Character string containing the arrow label.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{Arrow} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-source"></a>}}
\if{latex}{\out{\hypertarget{method-source}{}}}
\subsection{Method \code{source()}}{
Access source node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arrow$source()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Node from which the arrow leads.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-target"></a>}}
\if{latex}{\out{\hypertarget{method-target}{}}}
\subsection{Method \code{target()}}{
Access target node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arrow$target()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Node to which the arrow points.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Arrow$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
