% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AdExclusionRuleService.R
\name{dfp_createAdExclusionRules}
\alias{dfp_createAdExclusionRules}
\title{AdExclusionRuleService}
\usage{
dfp_createAdExclusionRules(request_data, as_df = TRUE, verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createAdExclusionRulesResponse
}
\description{
Provides methods for creating, updating and retrieving AdExclusionRule
objects.
An AdExclusionRule provides a way to block specified ads from
showing on portions of your site. Each rule specifies the inventory on
which the rule is in effect, and the labels to block on that inventory.
}
\details{
createAdExclusionRules

Creates new AdExclusionRule objects.
}
\examples{
\dontrun{
 res <- dfp_createAdExclusionRules(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201811/AdExclusionRuleService#createAdExclusionRules}{Google Documentation for createAdExclusionRules}
}
