% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LineItemCreativeAssociationService.R
\name{dfp_createLineItemCreativeAssociations}
\alias{dfp_createLineItemCreativeAssociations}
\title{LineItemCreativeAssociationService}
\usage{
dfp_createLineItemCreativeAssociations(request_data, as_df = TRUE,
  verbose = FALSE)
}
\arguments{
\item{request_data}{a \code{list} or \code{data.frame} of data elements
to be formatted for a SOAP
request (XML format, but passed as character string)}

\item{as_df}{a boolean indicating whether to attempt to parse the result into
a \code{data.frame}}

\item{verbose}{a boolean indicating whether to print the service URL and POSTed XML}
}
\value{
a \code{data.frame} or \code{list} containing all the elements of a createLineItemCreativeAssociationsResponse
}
\description{
Provides operations for creating, updating and retrieving
LineItemCreativeAssociation objects.
A line item creative association
(LICA) associates a Creative with a LineItem. When a line item is selected
to serve, the LICAs specify which creatives can appear for the ad units
that are targeted by the line item. In order to be associated with a line
item, the creative must have a size that exists within the attribute
LineItem#creativeSizes.#' Each LICA has a start and end date and
time that defines when the creative should be displayed.#' To read
more about associating creatives with line items, see this <a
href="https://support.google.com/dfp_premium/answer/3187916">DFP Help
Center</a> article.
}
\details{
createLineItemCreativeAssociations

Creates new LineItemCreativeAssociation objects
}
\examples{
\dontrun{
 res <- dfp_createLineItemCreativeAssociations(request_data)
}
}
\seealso{
\href{https://developers.google.com/ad-manager/api/reference/v201905/LineItemCreativeAssociationService#createLineItemCreativeAssociations}{Google Documentation for createLineItemCreativeAssociations}
}
