% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/play.R
\name{get_play_rdf}
\alias{get_play_rdf}
\title{Retrieve an RDF for a play}
\usage{
get_play_rdf(play = NULL, corpus = NULL, parse = TRUE, ...)
}
\arguments{
\item{play}{Character, name of a play (you can find all play names in
\code{"playName"} column within an object returned by
\code{\link{get_dracor}}). Character vector (longer than 1) is not
supported.}

\item{corpus}{Character, name of the corpus (you can find all corpus names in
\code{name} column within an object returned by
\code{\link{get_dracor_meta}}).}

\item{parse}{Logical, if \code{TRUE} the result is parsed by
{\code{\link[xml2:read_xml]{xml2::read_xml()}}}, otherwise character value is
returned. Default value is \code{TRUE}.}

\item{...}{Additional arguments passed to \code{\link{dracor_api}}.}
}
\value{
RDF data parsed by {\code{\link[xml2:read_xml]{xml2::read_xml()}}}.
}
\description{
\code{get_play_rdf()} requests an RDF (Resource Description Framework) data
for a play, given play and corpus names. RDF for plays can be useful for
extraction data for a play from
\url{https://www.wikidata.org/wiki/Wikidata:Main_Page}.
}
\examples{
get_play_rdf(play = "lessing-emilia-galotti", corpus = "ger")
# If you want RDF without parsing by xml2::read_xml():
get_play_rdf(play = "lessing-emilia-galotti", corpus = "ger", parse = FALSE)
}
\seealso{
\code{\link{get_play_metadata}} \code{\link{get_play_cast}}
}
