% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findID.R
\name{findID}
\alias{findID}
\title{find DWD weather station ID from name}
\usage{
findID(name = "", exactmatch = TRUE, mindex = metaIndex, quiet = FALSE)
}
\arguments{
\item{name}{Char: station name(s) that will be matched in \code{mindex} to obtain
\bold{id}. DEFAULT: ""}

\item{exactmatch}{Logical: Should \code{name} match an entry in \code{mindex}
exactly (be \code{\link{==}})?
If FALSE, \code{name} may be a part of \code{mindex$Stationsname},
as checked with \code{\link{grepl}}. This is useful e.g. to get
all stations starting with a name (e.g. 42 IDs for Berlin).
DEFAULT: TRUE}

\item{mindex}{Single object: Index used to select \code{id} if \code{name}
is given. DEFAULT: \code{rdwd:::\link{metaIndex}}}

\item{quiet}{Logical: suppress length warnings? DEFAULT: FALSE}
}
\value{
Character string (vector) with ID(s)
}
\description{
Identify DWD weather station ID from station name
}
\examples{
# Give weather station name (must be existing in metaIndex):
findID("Potsdam")
findID("potsDam") # capitalization is ignored
# all names containing "Hamburg":
findID("Hamburg", exactmatch=FALSE)
findID("Potsdam", exactmatch=FALSE)

# vectorized:
findID(c("Potsdam","Berlin-Buch"))

# German Umlauts are changed to ue, ae, oe, ss
findID("Muenchen", FALSE)
berryFunctions::convertUmlaut("M?nchen") # use this to convert umlauts in lists

}
\seealso{
used in \code{\link{selectDWD}}, \code{\link{metaInfo}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Oct-Nov 2016
}
\keyword{character}
