% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compile.R
\name{re2}
\alias{re2}
\title{Create a pre-compiled regular expression}
\usage{
re2(pattern, utf_8 = TRUE, case_sensitive = TRUE, posix_syntax = FALSE,
  dot_nl = FALSE, literal = FALSE, longest_match = FALSE,
  never_nl = FALSE, never_capture = FALSE, one_line = FALSE,
  perl_classes = FALSE, word_boundary = FALSE, log_error = FALSE,
  max_mem = 8388608, simplify = TRUE)
}
\arguments{
\item{pattern}{regular expression pattern}

\item{utf_8}{(true)  text and pattern are UTF-8; otherwise Latin-1}

\item{case_sensitive}{(true)  match is case-sensitive (regexp can override with (?i) unless in posix_syntax mode)}

\item{posix_syntax}{(false) restrict regexps to POSIX egrep syntax}

\item{dot_nl}{(false) dot matches everything including new line}

\item{literal}{(false) interpret string as literal, not regexp}

\item{longest_match}{(false) search for longest match, not first match}

\item{never_nl}{(false) never match \\n, even if it is in regexp}

\item{never_capture}{(false) parse all parens as non-capturing}

\item{one_line}{(false) ^ and $ only match beginning and end of text, when posix_syntax == false this features are always enabled}

\item{perl_classes}{(false) allow Perl's \\d \\s \\w \\D \\S \\W, when posix_syntax == false this features are always enabled}

\item{word_boundary}{(false) allow Perl's \\b \\B (word boundary and not), when posix_syntax == false this features are always enabled}

\item{log_error}{(false) log syntax and execution errors}

\item{max_mem}{(see details)  approx. max memory footprint of RE2}

\item{simplify}{(true) return a object instead of a list when pattern length is 1.}
}
\value{
a pre-compiled regular expression
}
\description{
Create a pre-compiled regular expression from a string.
}
\details{
The max_mem option controls how much memory can be used
to hold the compiled form of the regexp (the Prog) and
its cached DFA graphs.

Once a DFA fills its budget, it flushes its cache and starts over.
If this happens too often, RE2 falls back on the NFA implementation.

For now, make the default budget something close to Code Search.

Default maxmem = 8<<20 = 8388608;
}
\examples{
regexp = re2("test")
regexp

re2_match("abc\\ndef","(?s)(.*)")
re2_match("abc\\ndef", re2("(?s)(.*)", never_nl = TRUE))

re2_detect("\\n", re2(".", dot_nl = TRUE))
re2_detect("\\n", ".")

get_number_of_groups(re2("(A)(v)",never_capture = TRUE))

re2_match("aaabaaaa",re2("(a|aaa)",longest_match = TRUE))
re2_match("aaabaaaa",re2("(a|aaa)",longest_match = FALSE))

re2_match("a+b", re2("a+b", literal = TRUE))

re2_detect("abc" , re2("abc", posix_syntax = TRUE))
re2("(?P<name>re)")

\dontrun{

expect_error(re2("(?P<name>re)", posix_syntax = TRUE))
}

}
