% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reSurv.R
\name{reSurv}
\alias{reSurv}
\alias{reSurv}
\alias{is.reSurv}
\title{Create an \code{reSurv} Object}
\usage{
reSurv(time1, time2, event, status, id)

is.reSurv(x)
}
\arguments{
\item{time1}{when "time2" is provided, this vector is treated as the starting time for the gap time between two successive recurrent events.
In the absence of "time2", this is the observation time of recurrence on calendar time scale, in which, the time corresponds to the time since entry/inclusion in the study.}

\item{time2}{an optional vector for ending time for the gap time between two successive recurrent events.}

\item{event}{a binary vector used as the recurrent event indicator.}

\item{status}{a binary vector used as the status indicator for the terminal event.}

\item{id}{observation subject's id}

\item{x}{an \code{reSurv} object.}
}
\description{
Create a recurrent event survival object, used as a response variable in reReg model formula.
}
\examples{
data(readmission)
with(readmission, reSurv(t.stop, event, death, id))
with(readmission, reSurv(t.start, t.stop, event, death, id))
}
