\name{readGenalex-package}
\alias{readGenalex-package}
\alias{GenAlEx}
\alias{genotype}
\docType{package}
\title{
Read and manipulate GenAlEx-format genotype files
}
\description{
A collection of R functions to read and manipulate genotype data in GenAlEx format.  GenAlEx is a widely-used Excel plugin for manipulating and analysing genotype data.  This package reads GenAlEx data that has been exported from Excel as a delimited text file and creates an annotated \code{data.frame}.  Several functions are provided for accessing and printing this data.  GenAlEx and its documentation are available at \url{http://biology-assets.anu.edu.au/GenAlEx}.
}
\details{
\tabular{ll}{
Package: \tab readGenalex\cr
Type: \tab Package\cr
Version: \tab 0.4.1\cr
Date: \tab 2015-01-12\cr
License: \tab LGPL-3\cr
}
Read and manipulate GenAlEx-format data files.  \href{http://biology-assets.anu.edu.au/GenAlEx}{GenAlEx} is a widely-used plugin for Excel that manipulates and analyses genotype data.  This package is designed to read GenAlEx-format genotype files that have been exported from Excel as delimited text.  A description of the file format is available via \code{help(readGenalex)}.
}
\author{
Douglas G. Scofield

Maintainer: Douglas G. Scofield <douglasgscofield@gmail.com>
}
\references{
Peakall, R. and Smouse P.E. (2012) GenAlEx 6.5: genetic analysis in Excel. Population genetic software for teaching and research-an update. \emph{Bioinformatics} 28, 2537-2539.

Peakall, R. and Smouse P.E. (2006) GENALEX 6: genetic analysis in Excel. Population genetic software for teaching and research. \emph{Molecular Ecology Notes} 6, 288-295. 
}
\keyword{ package }
\keyword{ file }
\keyword{ manip }
\keyword{ attribute }
