# readODS

read ODS files into R

## how it works

ODS (Open Document Spreadsheets) files are basically a zip file with all the stuff in it.
The file `contents.xml` is a XML file containing all the numbers and formulas used in the ODS spreadsheets.


## Installation
### Stable version
From the CRAN with

```{r}
install.packages("readODS")
library(readODS)
```

### Development version

From github with the `devtools` package 
WARNING: THIS MAY BE UNSTABLE!

```{r}
if(!require(devtools)){
    install.packages("devtools")
    library(devtools)
}
detach("package:readODS")
remove.packages("readODS")
install_github(repo="readODS", username ="chainsawriot", ref="master")
library(readODS)
```

### Usage

```{r}
read_ods("table.ods", header = TRUE) ## return only the first sheet
read_ods("multisheet.ods", sheet = 2, formula_as_formula = TRUE) ## return the second sheet with formula read as formula
read.ods("multisheet.ods") ## for backward compatibility purpose, not recommended.
```

## Testing

Various ods files generated by LibreOffice Calc and Google Sheets have been tested. The package has been tested on Debian 8.


### License

GPL3
