% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_abs.R
\name{read_abs}
\alias{read_abs}
\alias{read_abs_series}
\title{Download, extract, and tidy ABS time series spreadsheets}
\usage{
read_abs(
  cat_no = NULL,
  tables = "all",
  series_id = NULL,
  path = Sys.getenv("R_READABS_PATH", unset = tempdir()),
  metadata = TRUE,
  show_progress_bars = TRUE,
  retain_files = TRUE,
  check_local = TRUE,
  release_date = "latest"
)

read_abs_series(series_id, ...)
}
\arguments{
\item{cat_no}{ABS catalogue number, as a string, including the extension.
For example, "6202.0".}

\item{tables}{numeric. Time series tables in \verb{cat_no`` to download and extract. Default is "all", which will read all time series in }cat_no\verb{. Specify }tables\verb{to download and import specific tables(s) - eg.}tables = 1\code{or}tables = c(1, 5)`.}

\item{series_id}{(optional) character. Supply an ABS unique time series
identifier (such as "A2325807L") to get only that series.
This is an alternative to specifying \code{cat_no}.}

\item{path}{Local directory in which downloaded ABS time series
spreadsheets should be stored. By default, \code{path} takes the value set in the
environment variable "R_READABS_PATH". If this variable is not set,
any files downloaded by read_abs()  will be stored in a temporary directory
(\code{tempdir()}). See \code{Details} below for
more information.}

\item{metadata}{logical. If \code{TRUE} (the default), a tidy data frame including
ABS metadata (series name, table name, etc.) is included in the output. If
\code{FALSE}, metadata is dropped.}

\item{show_progress_bars}{TRUE by default. If set to FALSE, progress bars
will not be shown when ABS spreadsheets are downloading.}

\item{retain_files}{when TRUE (the default), the spreadsheets downloaded
from the ABS website will be saved in the directory specified with \code{path}.
If set to \code{FALSE}, the files will be stored in a temporary directory.}

\item{check_local}{If \code{TRUE}, the default, local \code{fst} files are used,
if present.}

\item{release_date}{Either \code{"latest"} or a string coercible to a date, such as
\code{"2022-02-01"}. If \code{"latest"}, the latest release of the requested data will
be returned. If a date, (eg. \code{"2022-02-01"}) \code{read_abs()} will
attempt to download the data from that month's release. See \code{Details}.}

\item{...}{Arguments to \code{read_abs_series()} are passed to \code{read_abs()}.}
}
\value{
A data frame (tibble) containing the tidied data from the ABS time
series table(s).
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

\code{read_abs()} downloads ABS time series spreadsheets,
then extracts the data from those spreadsheets,
then tidies the data. The result is a single
data frame (tibble) containing tidied data.
}
\details{
\code{read_abs_series()} is a wrapper around \code{read_abs()}, with \code{series_id} as
the first argument.

\code{read_abs()} downloads spreadsheet(s) from the ABS containing time
series data. These files need to be saved somewhere on your disk.
This local directory can be controlled using the \code{path} argument to
\code{read_abs()}. If the \code{path} argument is not set, \code{read_abs()} will store
the files in a directory set in the "R_READABS_PATH" environment variable.
If this variable isn't set, files will be saved in a temporary directory.

To check the value of the "R_READABS_PATH" variable, run
\code{Sys.getenv("R_READABS_PATH")}. You can set the value of this variable
for a single session using \code{Sys.setenv(R_READABS_PATH = <path>)}.
If you would like to change this variable for all future R sessions, edit
your \code{.Renviron} file and add \code{R_READABS_PATH = <path>} line.
The easiest way to edit this file is using \code{usethis::edit_r_environ()}.

Certain corporate networks restrict your ability to download files in an R
session. On some of these networks, the \code{"wininet"} method must be used when
downloading files. Users can now specify the method that will be used to
download files by setting the \code{"R_READABS_DL_METHOD"} environment variable.

For example, the following code sets the environment variable for your
current session: s\code{Sys.setenv("R_READABS_DL_METHOD" = "wininet")}
You can add \code{"R_READABS_DL_METHOD"} to your .Rprofile to have this persist across sessions.

The \code{release_date} argument allows you to download table(s) other than the
latest release. This is useful for examining revisions to time series, or
for obtaining the version of series that were available on a given date.
Note that you cannot supply more than one date to \code{release_date}. Note also
that any dates prior to mid-2019 (the exact date varies by series) will fail.
}
\examples{

# Download and tidy all time series spreadsheets
# from the Wage Price Index (6345.0)
\dontrun{
wpi <- read_abs("6345.0")
}

# Download table 1 from the Wage Price Index
\dontrun{
wpi_t1 <- read_abs("6345.0", tables = "1")
}

# Or table 1 as in the Sep 2019 release of the WPI:
\dontrun{
wpi_t1_sep2019 <- read_abs("6345.0", tables = "1", release_date = "2019-09-01")
}

# Or tables 1 and 2a from the WPI
\dontrun{
wpi_t1_t2a <- read_abs("6345.0", tables = c("1", "2a"))
}


# Get two specific time series, based on their time series IDs
\dontrun{
cpi <- read_abs(series_id = c("A2325806K", "A2325807L"))
}

# Get series IDs using the `read_abs_series()` wrapper function
\dontrun{
cpi <- read_abs_series(c("A2325806K", "A2325807L"))
}
}
