% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collectors.R
\name{collector}
\alias{col_character}
\alias{col_double}
\alias{col_euro_double}
\alias{col_factor}
\alias{col_guess}
\alias{col_integer}
\alias{col_logical}
\alias{col_number}
\alias{col_numeric}
\alias{col_skip}
\alias{collector}
\alias{parse_character}
\alias{parse_double}
\alias{parse_euro_double}
\alias{parse_factor}
\alias{parse_guess}
\alias{parse_integer}
\alias{parse_logical}
\alias{parse_number}
\alias{parse_numeric}
\title{Parse character vectors into typed columns.}
\usage{
parse_guess(x, na = c("", "NA"), locale = default_locale())

col_character()

parse_character(x, na = c("", "NA"), locale = default_locale())

col_integer()

parse_integer(x, na = c("", "NA"), locale = default_locale())

col_double()

parse_double(x, na = c("", "NA"), locale = default_locale())

col_euro_double()

parse_euro_double(x, na = c("", "NA"))

col_number()

parse_number(x, na = c("", "NA"), locale = default_locale())

col_logical()

parse_logical(x, na = c("", "NA"), locale = default_locale())

col_factor(levels, ordered = FALSE)

parse_factor(x, levels, ordered = FALSE, na = c("", "NA"),
  locale = default_locale())

col_skip()

col_guess()
}
\arguments{
\item{x}{Character vector of values to parse.}

\item{na}{Character vector of strings to use for missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link{locale}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{levels}{Character vector providing set of allowed levels.}

\item{ordered}{Is it an ordered factor?}
}
\description{
Use \code{parse_} if you have a character vector you want to parse. Use
\code{col_} in conjunction with a \code{read_} function to parse the
values as they're read in.
}
\examples{
parse_integer(c("1", "2", "3"))
parse_double(c("1", "2", "3.123"))
parse_factor(c("a", "b"), letters)
parse_number("$1,123,456.00")

# Use locale to override default decimal and grouping marks
es_MX <- locale("es", decimal_mark = ",")
parse_number("$1.123.456,00", locale = es_MX)

# Invalid values are replaced with missing values with a warning.
x <- c("1", "2", "3", "-")
parse_double(x)
# Or flag values as missing
parse_double(x, na = "-")
}
\seealso{
\code{\link{parse_datetime}}, \code{\link{type_convert}} to
  automatically re-parse all character columns in a data frame.
}

