% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/melt_delim.R
\name{melt_delim}
\alias{melt_delim}
\alias{melt_csv}
\alias{melt_csv2}
\alias{melt_tsv}
\title{Return melted data for each token in a delimited file (including csv & tsv)}
\usage{
melt_delim(file, delim, quote = "\\"", escape_backslash = FALSE,
  escape_double = TRUE, locale = default_locale(), na = c("", "NA"),
  quoted_na = TRUE, comment = "", trim_ws = FALSE, skip = 0,
  n_max = Inf, progress = show_progress(), skip_empty_rows = FALSE)

melt_csv(file, locale = default_locale(), na = c("", "NA"),
  quoted_na = TRUE, quote = "\\"", comment = "", trim_ws = TRUE,
  skip = 0, n_max = Inf, progress = show_progress(),
  skip_empty_rows = FALSE)

melt_csv2(file, locale = default_locale(), na = c("", "NA"),
  quoted_na = TRUE, quote = "\\"", comment = "", trim_ws = TRUE,
  skip = 0, n_max = Inf, progress = show_progress(),
  skip_empty_rows = FALSE)

melt_tsv(file, locale = default_locale(), na = c("", "NA"),
  quoted_na = TRUE, quote = "\\"", comment = "", trim_ws = TRUE,
  skip = 0, n_max = Inf, progress = show_progress(),
  skip_empty_rows = FALSE)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \code{http://},
\code{https://}, \code{ftp://}, or \code{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. It must contain at
least one new line to be recognised as data (instead of a path) or be a
vector of greater than length 1.

Using a value of \code{\link[=clipboard]{clipboard()}} will read from the system clipboard.}

\item{delim}{Single character used to separate fields within a record.}

\item{quote}{Single character used to quote strings.}

\item{escape_backslash}{Does the file use backslashes to escape special
characters? This is more general than \code{escape_double} as backslashes
can be used to escape the delimiter character, the quote character, or
to add special characters like \code{\\n}.}

\item{escape_double}{Does the file escape quotes by doubling them?
i.e. If this option is \code{TRUE}, the value \code{""""} represents
a single quote, \code{\"}.}

\item{locale}{The locale controls defaults that vary from place to place.
The default locale is US-centric (like R), but you can use
\code{\link[=locale]{locale()}} to create your own locale that controls things like
the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{na}{Character vector of strings to interpret as missing values. Set this
option to \code{character()} to indicate no missing values.}

\item{quoted_na}{Should missing values inside quotes be treated as missing
values (the default) or strings.}

\item{comment}{A string used to identify comments. Any text after the
comment characters will be silently ignored.}

\item{trim_ws}{Should leading and trailing whitespace be trimmed from
each field before parsing it?}

\item{skip}{Number of lines to skip before reading data.}

\item{n_max}{Maximum number of records to read.}

\item{progress}{Display a progress bar? By default it will only display
in an interactive session and not while knitting a document. The display
is updated every 50,000 values and will only display if estimated reading
time is 5 seconds or more. The automatic progress bar can be disabled by
setting option \code{readr.show_progress} to \code{FALSE}.}

\item{skip_empty_rows}{Should blank rows be ignored altogether? i.e. If this
option is \code{TRUE} then blank rows will not be represented at all.  If it is
\code{FALSE} then they will be represented by \code{NA} values in all the columns.}
}
\value{
A \code{\link[=tibble]{tibble()}} of four columns:
\itemize{
\item \code{row}, the row that the token comes from in the original file
\item \code{col}, the column that the token comes from in the original file
\item \code{data_type}, the data type of the token, e.g. \code{"integer"}, \code{"character"},
\code{"date"}, guessed in a similar way to the \code{guess_parser()} function.
\item \code{value}, the token itself as a character string, unchanged from its
representation in the original file.
}

If there are parsing problems, a warning tells you
how many, and you can retrieve the details with \code{\link[=problems]{problems()}}.
}
\description{
For certain non-rectangular data formats, it can be useful to parse the data
into a melted format where each row represents a single token.
}
\details{
\code{melt_csv()} and \code{melt_tsv()} are special cases of the general
\code{melt_delim()}. They're useful for reading the most common types of
flat file data, comma separated values and tab separated values,
respectively. \code{melt_csv2()} uses \code{;} for the field separator and \code{,} for the
decimal point. This is common in some European countries.
}
\examples{
# Input sources -------------------------------------------------------------
# Read from a path
melt_csv(readr_example("mtcars.csv"))
melt_csv(readr_example("mtcars.csv.zip"))
melt_csv(readr_example("mtcars.csv.bz2"))
\dontrun{
melt_csv("https://github.com/tidyverse/readr/raw/master/inst/extdata/mtcars.csv")
}

# Or directly from a string (must contain a newline)
melt_csv("x,y\\n1,2\\n3,4")

# To import empty cells as 'empty' rather than `NA`
melt_csv("x,y\\n,NA,\\"\\",''", na = "NA")

# File types ----------------------------------------------------------------
melt_csv("a,b\\n1.0,2.0")
melt_csv2("a;b\\n1,0;2,0")
melt_tsv("a\\tb\\n1.0\\t2.0")
melt_delim("a|b\\n1.0|2.0", delim = "|")
}
\seealso{
\code{\link[=read_delim]{read_delim()}} for the conventional way to read rectangular data
from delimited files.
}
