% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_builtin.R
\name{read_builtin}
\alias{read_builtin}
\title{Read built-in object from package}
\usage{
read_builtin(x, package = NULL)
}
\arguments{
\item{x}{Name (character string) of data set to read.}

\item{package}{Name of package from which to find data set. By default, all
attached packages are searched and then the 'data' subdirectory (if present)
of the current working directory.}
}
\value{
An object of the built-in class of \code{x}.
}
\description{
Consistent wrapper around \code{\link[=data]{data()}} that forces the promise. This is also a
stronger parallel to loading data from a file.
}
\examples{
if (requireNamespace("dplyr")) {
  read_builtin("starwars", "dplyr")

  read_builtin("storms", "dplyr")
}
}
