% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.R
\name{write_delim}
\alias{write_delim}
\alias{write_csv}
\alias{write_csv2}
\alias{write_excel_csv}
\alias{write_excel_csv2}
\alias{write_tsv}
\title{Write a data frame to a delimited file}
\usage{
write_delim(
  x,
  file,
  delim = " ",
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote_escape = "double",
  eol = "\\n",
  path = deprecated()
)

write_csv(
  x,
  file,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote_escape = "double",
  eol = "\\n",
  path = deprecated()
)

write_csv2(
  x,
  file,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote_escape = "double",
  eol = "\\n",
  path = deprecated()
)

write_excel_csv(
  x,
  file,
  na = "NA",
  append = FALSE,
  col_names = !append,
  delim = ",",
  quote_escape = "double",
  eol = "\\n",
  path = deprecated()
)

write_excel_csv2(
  x,
  file,
  na = "NA",
  append = FALSE,
  col_names = !append,
  delim = ";",
  quote_escape = "double",
  eol = "\\n",
  path = deprecated()
)

write_tsv(
  x,
  file,
  na = "NA",
  append = FALSE,
  col_names = !append,
  quote_escape = "double",
  eol = "\\n",
  path = deprecated()
)
}
\arguments{
\item{x}{A data frame or tibble to write to disk.}

\item{file}{File or connection to write to.}

\item{delim}{Delimiter used to separate values. Defaults to \code{" "} for \code{write_delim()}, \code{","} for \code{write_excel_csv()} and
\code{";"} for \code{write_excel_csv2()}. Must be a single character.}

\item{na}{String used for missing values. Defaults to NA. Missing values
will never be quoted; strings with the same value as \code{na} will
always be quoted.}

\item{append}{If \code{FALSE}, will overwrite existing file. If \code{TRUE},
will append to existing file. In both cases, if the file does not exist a new
file is created.}

\item{col_names}{If \code{FALSE}, column names will not be included at the top of the file. If \code{TRUE},
column names will be included. If not specified, \code{col_names} will take the opposite value given to \code{append}.}

\item{quote_escape}{The type of escaping to use for quoted values, one of
\code{"double"}, \code{"backslash"} or \code{"none"}. You can also use \code{FALSE}, which is
equivalent to "none". The default is \code{"double"}, which is expected format for Excel.}

\item{eol}{The end of line character to use. Most commonly either \code{"\\n"} for
Unix style newlines, or \code{"\\r\\n"} for Windows style newlines.}

\item{path}{\Sexpr[results=rd, stage=render]{lifecycle::badge("deprecated")}}
}
\value{
\verb{write_*()} returns the input \code{x} invisibly.
}
\description{
The \verb{write_*()} family of functions are an improvement to analogous function such
as \code{\link[=write.csv]{write.csv()}} because they are approximately twice as fast. Unlike \code{\link[=write.csv]{write.csv()}},
these functions do not include row names as a column in the written file.
A generic function, \code{output_column()}, is applied to each variable
to coerce columns to suitable output.
}
\section{Output}{

Factors are coerced to character. Doubles are formatted to a decimal string
using the grisu3 algorithm. \code{POSIXct} values are formatted as ISO8601 with a
UTC timezone \emph{Note: \code{POSIXct} objects in local or non-UTC timezones will be
converted to UTC time before writing.}

All columns are encoded as UTF-8. \code{write_excel_csv()} and \code{write_excel_csv2()} also include a
\href{https://en.wikipedia.org/wiki/Byte_order_mark}{UTF-8 Byte order mark}
which indicates to Excel the csv is UTF-8 encoded.

\code{write_excel_csv2()} and \code{write_csv2} were created to allow users with
different locale settings to save .csv files using their default settings
(e.g. \verb{;} as the column separator and \verb{,} as the decimal separator).
This is common in some European countries.

Values are only quoted if they contain a comma, quote or newline.

The \verb{write_*()} functions will automatically compress outputs if an appropriate extension is given.
Three extensions are currently supported: \code{.gz} for gzip compression, \code{.bz2} for bzip2 compression and
\code{.xz} for lzma compression.  See the examples for more information.
}

\examples{
\dontshow{
.old_wd <- setwd(tempdir())
}
data(storms, package = "dplyr")
# If only a file name is specified, write_()* will write
# the file to the current working directory.
write_csv(storms, "storms.csv")
write_tsv(storms, "storms.tsv")

# If you add an extension to the file name, write_()* will
# automatically compress the output.
write_tsv(storms, "storms.tsv.gz")
write_tsv(storms, "storms.tsv.bz2")
write_tsv(storms, "storms.tsv.xz")

\dontshow{setwd(.old_wd)}
}
\references{
Florian Loitsch, Printing Floating-Point Numbers Quickly and
Accurately with Integers, PLDI '10,
\url{http://www.cs.tufts.edu/~nr/cs257/archive/florian-loitsch/printf.pdf}
}
