% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{rws_read.SQLiteConnection}
\alias{rws_read.SQLiteConnection}
\title{Read All Tables from a SQLite Database}
\usage{
\method{rws_read}{SQLiteConnection}(x, meta = TRUE, ...)
}
\arguments{
\item{x}{A \linkS4class{SQLiteConnection} to a database.}

\item{meta}{A flag specifying whether to preserve meta data.}

\item{...}{Not used.}
}
\value{
A named list of the data frames.
}
\description{
Read All Tables from a SQLite Database
}
\examples{
conn <- rws_connect()
rws_write(rws_data, exists = FALSE, conn = conn)
rws_write(rws_data[c("date", "ordered")],
  x_name = "data2", exists = FALSE, conn = conn
)
rws_read(conn)
rws_disconnect(conn)
}
\seealso{
Other rws_read: 
\code{\link{rws_describe_meta.data.frame}()},
\code{\link{rws_read.character}()},
\code{\link{rws_read}()}
}
\concept{rws_read}
