library(rearrr)
context("shear_2d()")


test_that("fuzz testing shear_2d()", {
  xpectr::set_test_seed(42)

  # Create a data frame
  df <- data.frame(
    "x" = runif(15),
    "y" = runif(15),
    "z" = runif(15),
    "g" = rep(c(1, 2, 3, 4, 5), each = 3),
    stringsAsFactors = FALSE
  ) %>%
    dplyr::as_tibble()


  ## Testing 'df'                                                           ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(df),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    df[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    df[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    df[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    df[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(df),
    c("x", "y", "z", "g"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(df),
    c("numeric", "numeric", "numeric", "numeric"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(df),
    c("double", "double", "double", "double"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(df),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(df)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'df'                                                  ####


  # Generate expectations for 'swirl_2d'
  # Tip: comment out the gxs_function() call
  # so it is easy to regenerate the tests
  xpectr::set_test_seed(42)
  # xpectr::gxs_function(
  #   fn = shear_2d,
  #   args_values = list(
  #     "data" = list(df, dplyr::group_by(df, g), c(1, 2, 3, 4, 5), "hej", NA),
  #     "x_shear" = list(1, 0, -1, 10, c(1, 2, 3), NA),
  #     "y_shear" = list(0, 1, -1, 10, c(1, 2, 3), NA),
  #     "x_col" = list("x", "y", NA),
  #     "y_col" = list("y", "x", NA),
  #     "suffix" = list("", "_sheared", NA),
  #     "origin" = list(c(0, 0), c(NA, 0), c(0, 0, 0), NA),
  #     "origin_fn" = list(NULL, centroid, most_centered),
  #     "keep_original" = list(FALSE),
  #     "shear_col_name" = list(".shear", ".sha"),
  #     "origin_col_name" = list(".origin", ".origi"),
  #     "overwrite" = list(TRUE, FALSE)
  #   ),
  #   extra_combinations = list(
  #     list("data" = c(1, 2, 3, 4, 5), "x_col" = NULL, "y_col" = NULL, "origin_fn" = centroid,  "origin" = NULL),
  #     list("data" = c(1, 2, 3, 4, 5), "x_col" = "x", "y_col" = NULL, "origin_fn" = centroid, "origin" = NULL),
  #     list("data" = dplyr::group_by(df, g), "origin_fn" = centroid,  "origin" = NULL),
  #     list("keep_original" = TRUE, "suffix" = "_shearly"),
  #     list("overwrite" = FALSE, "shear_col_name" = "g")
  #   ),
  #   indentation = 2
  # )


  ## Testing 'shear_2d'                                                       ####
  ## Initially generated by xpectr
  # Testing different combinations of argument values

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19148 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19148),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19148[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19148[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19148[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19148),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19148),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19148),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19148),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19148)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = dplyr::group_by(df, g), x_sh...
  # Changed from baseline: data = dplyr::group_b...
  xpectr::set_test_seed(42)
  # Assigning output
  output_19370 <- shear_2d(data = dplyr::group_by(df, g), x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19370),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19370[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19370[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19370[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19370),
    c("g", "x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19370),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19370),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19370),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19370)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = c(1, 2, 3, 4, 5), x_shear = ...
  # Changed from baseline: data = c(1, 2, 3, 4, 5)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12861 <- xpectr::capture_side_effects(shear_2d(data = c(1, 2, 3, 4, 5), x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12861[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = "hej", x_shear = 1, y_shear ...
  # Changed from baseline: data = "hej"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18304 <- xpectr::capture_side_effects(shear_2d(data = "hej", x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18304[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = NA, x_shear = 1, y_shear = 0...
  # Changed from baseline: data = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16417 <- xpectr::capture_side_effects(shear_2d(data = NA, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'logical'\n * checkmate::check_vector(data): Contains missing values (element 1)\n * checkmate::check_factor(data): Contains missing values (element 1)"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16417[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = NULL, x_shear = 1, y_shear =...
  # Changed from baseline: data = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15190 <- xpectr::capture_side_effects(shear_2d(data = NULL, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error']]),
    xpectr::strip("Assertion failed. One of the following must apply:\n * checkmate::check_data_frame(data): Must be of type 'data.frame', not 'NULL'\n * checkmate::check_vector(data): Must be of type 'vector', not 'NULL'\n * checkmate::check_factor(data): Must be of type 'factor', not 'NULL'"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15190[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = dplyr::group_by(df, g), x_sh...
  # Changed from baseline: data, origin, origin_fn
  xpectr::set_test_seed(42)
  # Assigning output
  output_17365 <- shear_2d(data = dplyr::group_by(df, g), x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17365),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17365[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["x"]],
    c(1.17624, 1.23673, -0.27495, 0.65899, 0.55562, 0.77667, 0.18388,
      0.43213, 0.91224, 0.45855, 0.643, 0.78036, 1.11084, -0.02717,
      0.56873),
    tolerance = 1e-4)
  expect_equal(
    output_17365[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17365[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17365),
    c("g", "x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17365),
    c("numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17365),
    c("double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17365),
    c(15L, 6L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17365)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = c(1, 2, 3, 4, 5), x_shear = ...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_11346 <- shear_2d(data = c(1, 2, 3, 4, 5), x_shear = 1, y_shear = 0, x_col = NULL, y_col = NULL, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11346[["Index"]],
    c(-1, 1, 3, 5, 7),
    tolerance = 1e-4)
  expect_equal(
    output_11346[["Value"]],
    c(1, 2, 3, 4, 5),
    tolerance = 1e-4)
  expect_equal(
    output_11346[[".shear_str"]],
    c("Index=1,Value=0", "Index=1,Value=0", "Index=1,Value=0", "Index=1,Value=0",
      "Index=1,Value=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_11346),
    c("Index", "Value", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11346),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11346),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11346),
    c(5L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11346)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = c(1, 2, 3, 4, 5), x_shear = ...
  # Changed from baseline: data, x_col, y_col, o...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16569 <- xpectr::capture_side_effects(shear_2d(data = c(1, 2, 3, 4, 5), x_shear = 1, y_shear = 0, x_col = "x", y_col = NULL, suffix = "", origin = NULL, origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is not a data.frame, 'col(s)' must be 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16569[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 0, y_shear = 0...
  # Changed from baseline: x_shear = 0
  xpectr::set_test_seed(42)
  # Assigning output
  output_17050 <- shear_2d(data = df, x_shear = 0, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17050),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17050[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_17050[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17050[[".shear_str"]],
    c("x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0",
      "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0", "x=0,y=0",
      "x=0,y=0", "x=0,y=0", "x=0,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17050),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17050),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17050),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17050),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17050)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = -1, y_shear = ...
  # Changed from baseline: x_shear = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_14577 <- shear_2d(data = df, x_shear = -1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14577),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14577[["x"]],
    c(-0.02521, -0.04115, 0.16865, 0.35545, 0.08141, -0.38494, 0.59788,
      -0.85423, -0.28968, 0.62263, -0.05647, 0.32891, 0.02893, -0.19154,
      -0.37371),
    tolerance = 1e-4)
  expect_equal(
    output_14577[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_14577[[".shear_str"]],
    c("x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0",
      "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0",
      "x=-1,y=0", "x=-1,y=0", "x=-1,y=0", "x=-1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14577),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14577),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14577),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14577),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14577)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 10, y_shear = ...
  # Changed from baseline: x_shear = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_17191 <- shear_2d(data = df, x_shear = 10, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17191),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17191[["x"]],
    c(10.31495, 10.71934, 1.46101, 5.58042, 6.24507, 9.55941, 2.12369,
      10.02358, 10.12367, 1.52944, 5.59986, 4.62115, 9.99205, 4.72513,
      8.82234),
    tolerance = 1e-4)
  expect_equal(
    output_17191[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17191[[".shear_str"]],
    c("x=10,y=0", "x=10,y=0", "x=10,y=0", "x=10,y=0", "x=10,y=0", "x=10,y=0",
      "x=10,y=0", "x=10,y=0", "x=10,y=0", "x=10,y=0", "x=10,y=0",
      "x=10,y=0", "x=10,y=0", "x=10,y=0", "x=10,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17191),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17191),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17191),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17191),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17191)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = c(1, 2, 3), y_...
  # Changed from baseline: x_shear = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Assigning output
  output_19346 <- shear_2d(data = df, x_shear = c(1, 2, 3), y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19346),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_19346[["x"]], n = 30),
    c(1.9153, 1.30544, 1.42313, 1.12356, 1.60366, 0.97195, 1.84041,
      0.7024, 1.2983, 2.89353, 1.78044, 2.32716, 2.11245, 0.86994,
      1.48617, 1.49952, 2.74615, 1.14937, 2.1343, 3.73485, 0.6386,
      2.25544, 2.32274, 1.15272, 3.497, 0.95238, 1.88972, 3.65189,
      1.59634, 2.97031),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19346[["y"]], n = 30),
    c(0.97823, 0.475, 0.90403, 0.98889, 0.94667, 0.51421, 0.90574, 0.44697,
      0.836, 0.97823, 0.475, 0.90403, 0.98889, 0.08244, 0.51421, 0.3902,
      0.90574, 0.44697, 0.836, 0.94001, 0.11749, 0.475, 0.56033, 0.13871,
      0.94667, 0.08244, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_19346[[".shear_str"]], n = 30),
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=2,y=0", "x=2,y=0", "x=2,y=0",
      "x=2,y=0", "x=2,y=0", "x=2,y=0", "x=2,y=0", "x=2,y=0", "x=2,y=0",
      "x=2,y=0", "x=3,y=0", "x=3,y=0", "x=3,y=0", "x=3,y=0", "x=3,y=0",
      "x=3,y=0", "x=3,y=0", "x=3,y=0", "x=3,y=0", "x=3,y=0", "x=3,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19346),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19346),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19346),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19346),
    c(45L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19346)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = NA, y_shear = ...
  # Changed from baseline: x_shear = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12554 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = NA, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_shear': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12554[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = NULL, y_shear ...
  # Changed from baseline: x_shear = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14622 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = NULL, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_shear': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14622[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # NOTE: This becomes matrix multiplication with a [[1,1][1,1]] matrix
  # why we indeed should expect the two columns to be identical!
  # Testing shear_2d(data = df, x_shear = 1, y_shear = 1...
  # Changed from baseline: y_shear = 1
  xpectr::set_test_seed(42)
  # Assigning output
  output_19400 <- shear_2d(data = df, x_shear = 1, y_shear = 1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19400),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19400[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19400[["y"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19400[[".shear_str"]],
    c("x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1",
      "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1",
      "x=1,y=1", "x=1,y=1", "x=1,y=1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19400),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19400),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19400),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19400),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19400)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = -...
  # Changed from baseline: y_shear = -1
  xpectr::set_test_seed(42)
  # Assigning output
  output_19782 <- shear_2d(data = df, x_shear = 1, y_shear = -1, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19782),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19782[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19782[["y"]],
    c(0.02521, 0.04115, -0.16865, -0.35545, -0.08141, 0.38494, -0.59788,
      0.85423, 0.28968, -0.62263, 0.05647, -0.32891, -0.02893, 0.19154,
      0.37371),
    tolerance = 1e-4)
  expect_equal(
    output_19782[[".shear_str"]],
    c("x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1",
      "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1",
      "x=1,y=-1", "x=1,y=-1", "x=1,y=-1", "x=1,y=-1"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19782),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19782),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19782),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19782),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19782)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 1...
  # Changed from baseline: y_shear = 10
  xpectr::set_test_seed(42)
  # Assigning output
  output_11174 <- shear_2d(data = df, x_shear = 1, y_shear = 10, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_11174),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_11174[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_11174[["y"]],
    c(10.08807, 10.34898, 2.97888, 8.77947, 6.97779, 6.09499, 7.50459,
      2.33556, 7.51659, 7.13309, 5.09163, 7.58133, 10.25246, 3.00126,
      5.45893),
    tolerance = 1e-4)
  expect_equal(
    output_11174[[".shear_str"]],
    c("x=1,y=10", "x=1,y=10", "x=1,y=10", "x=1,y=10", "x=1,y=10", "x=1,y=10",
      "x=1,y=10", "x=1,y=10", "x=1,y=10", "x=1,y=10", "x=1,y=10",
      "x=1,y=10", "x=1,y=10", "x=1,y=10", "x=1,y=10"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_11174),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_11174),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_11174),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_11174),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_11174)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = c...
  # Changed from baseline: y_shear = c(1, 2, 3)
  xpectr::set_test_seed(42)
  # Assigning output
  output_14749 <- shear_2d(data = df, x_shear = 1, y_shear = c(1, 2, 3), x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14749),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    xpectr::smpl(output_14749[["x"]], n = 30),
    c(1.9153, 1.30544, 1.42313, 1.12356, 1.60366, 0.97195, 1.84041,
      0.7024, 1.2983, 1.9153, 1.30544, 1.42313, 1.12356, 0.7875, 0.97195,
      1.10932, 1.84041, 0.7024, 1.2983, 1.85482, 0.40363, 1.30544,
      1.20208, 0.8753, 1.60366, 0.7875, 1.10932, 1.84041, 0.7024,
      1.2983),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_14749[["y"]], n = 30),
    c(1.9153, 1.30544, 1.42313, 1.12356, 1.60366, 0.97195, 1.84041,
      0.7024, 1.2983, 2.85238, 2.13589, 1.94222, 1.25822, 1.49257,
      1.4297, 1.82843, 2.77508, 0.95783, 1.76059, 3.68443, 0.97591,
      2.96634, 2.48557, 2.34848, 2.91765, 2.19763, 2.54754, 3.70975,
      1.21326, 2.22288),
    tolerance = 1e-4)
  expect_equal(
    xpectr::smpl(output_14749[[".shear_str"]], n = 30),
    c("x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=1",
      "x=1,y=1", "x=1,y=1", "x=1,y=1", "x=1,y=2", "x=1,y=2", "x=1,y=2",
      "x=1,y=2", "x=1,y=2", "x=1,y=2", "x=1,y=2", "x=1,y=2", "x=1,y=2",
      "x=1,y=2", "x=1,y=3", "x=1,y=3", "x=1,y=3", "x=1,y=3", "x=1,y=3",
      "x=1,y=3", "x=1,y=3", "x=1,y=3", "x=1,y=3", "x=1,y=3", "x=1,y=3"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14749),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14749),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14749),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14749),
    c(45L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14749)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = N...
  # Changed from baseline: y_shear = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15603 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = NA, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_shear': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15603[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = N...
  # Changed from baseline: y_shear = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19040 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = NULL, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_shear': Must be of type 'numeric', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19040[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: x_col = "y"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_11387 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "y", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_col' and 'y_col' cannot be the same column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_11387[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: x_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19888 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = NA, y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'x_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19888[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: x_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19466 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = NULL, y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'x_col' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19466[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: y_col = "x"
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10824 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "x", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error']]),
    xpectr::strip("1 assertions failed:\n * 'x_col' and 'y_col' cannot be the same column."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10824[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: y_col = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_15142 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = NA, suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'y_col': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_15142[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: y_col = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13902 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = NULL, suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error']]),
    xpectr::strip("1 assertions failed:\n * when 'data' is a data.frame, 'y_col' must be specified."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13902[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: suffix = "_sheared"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19057 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "_sheared", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19057),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19057[["x_sheared"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19057[["y_sheared"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19057[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19057),
    c("x_sheared", "y_sheared", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19057),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19057),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19057),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19057)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: suffix = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14469 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = NA, origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': May not be NA."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14469[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: suffix = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18360 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = NULL, origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'suffix': Must be of type 'string', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18360[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: suffix, keep_original
  xpectr::set_test_seed(42)
  # Assigning output
  output_17375 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "_shearly", origin = c(0, 0), origin_fn = NULL, keep_original = TRUE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_17375),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_17375[["x"]],
    c(0.91481, 0.93708, 0.28614, 0.83045, 0.64175, 0.5191, 0.73659,
      0.13467, 0.65699, 0.70506, 0.45774, 0.71911, 0.93467, 0.25543,
      0.46229),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["z"]],
    c(0.7376, 0.81106, 0.38811, 0.68517, 0.00395, 0.83292, 0.00733,
      0.20766, 0.9066, 0.61178, 0.37956, 0.43577, 0.03743, 0.97354,
      0.43175),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["g"]],
    c(1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4, 5, 5, 5),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["x_shearly"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_17375[["y_shearly"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_17375[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_17375),
    c("x", "y", "z", "g", "x_shearly", "y_shearly", ".origin", ".shear",
      ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_17375),
    c("numeric", "numeric", "numeric", "numeric", "numeric", "numeric",
      "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_17375),
    c("double", "double", "double", "double", "double", "double", "list",
      "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_17375),
    c(15L, 9L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_17375)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin = c(NA, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18110 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(NA, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Contains missing values (element 1)."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18110[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin = c(0, 0, 0)
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13881 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 2, but has length 3."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13881[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin = NA
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_16851 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = NA, origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'origin': Must have length 2, but has length 1."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_16851[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10039 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = NULL, origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error']]),
    xpectr::strip("1 assertions failed:\n * At least one of {'origin', 'origin_fn'} must be specified (not 'NULL')."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10039[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin_fn = centroid
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_18329 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_18329[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_18329 <- xpectr::suppress_mw(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = centroid, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_18329),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_18329[["x"]],
    c(1.23983, 1.30031, -0.21137, 0.69045, 0.58708, 0.80813, 0.2603,
      0.50856, 0.98867, 0.17251, 0.35696, 0.49432, 1.22542, 0.0874,
      0.6833),
    tolerance = 1e-4)
  expect_equal(
    output_18329[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_18329[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_18329),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_18329),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_18329),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_18329),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_18329)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin_fn = most_cent...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_10073 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = most_centered, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['warnings']]),
    xpectr::strip(character(0)),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_10073[['messages']]),
    xpectr::strip("When 'origin_fn' is specified, 'origin' is ignored.\n"),
    fixed = TRUE)
  # Assigning output
  output_10073 <- xpectr::suppress_mw(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = most_centered, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE))
  # Testing class
  expect_equal(
    class(output_10073),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10073[["x"]],
    c(1.29449, 1.35497, -0.15671, 0.74511, 0.64175, 0.86279, 0.31497,
      0.56323, 1.04333, 0.22717, 0.41162, 0.54898, 1.28008, 0.14207,
      0.73796),
    tolerance = 1e-4)
  expect_equal(
    output_10073[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_10073[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10073),
    c("x", "y", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10073),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10073),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10073),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10073)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: keep_original = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_12076 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = NULL, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = TRUE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error']]),
    xpectr::strip("1 assertions failed:\n * Variable 'keep_original': Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_12076[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: shear_col_name = ".sha"
  xpectr::set_test_seed(42)
  # Assigning output
  output_19066 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".sha", origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_19066),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_19066[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_19066[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_19066[[".sha_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_19066),
    c("x", "y", ".origin", ".sha", ".sha_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_19066),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_19066),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_19066),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_19066)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: shear_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_16117 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = NULL, origin_col_name = ".origin", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_16117),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_16117[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_16117[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  # Testing column names
  expect_equal(
    names(output_16117),
    c("x", "y", ".origin"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_16117),
    c("numeric", "numeric", "list"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_16117),
    c("double", "double", "list"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_16117),
    c(15L, 3L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_16117)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: shear_col_name, overw...
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_13795 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = "g", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error']]),
    xpectr::strip("1 assertions failed:\n * The column 'g' already exists and 'overwrite' is disabled."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_13795[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin_col_name = ".o...
  xpectr::set_test_seed(42)
  # Assigning output
  output_14357 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origi", overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_14357),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_14357[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_14357[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_14357[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_14357),
    c("x", "y", ".origi", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_14357),
    c("numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_14357),
    c("double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_14357),
    c(15L, 5L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_14357)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: origin_col_name = NULL
  xpectr::set_test_seed(42)
  # Assigning output
  output_10374 <- shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = NULL, overwrite = TRUE)
  # Testing class
  expect_equal(
    class(output_10374),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    output_10374[["x"]],
    c(1.85482, 1.9153, 0.40363, 1.30544, 1.20208, 1.42313, 0.8753, 1.12356,
      1.60366, 0.7875, 0.97195, 1.10932, 1.84041, 0.7024, 1.2983),
    tolerance = 1e-4)
  expect_equal(
    output_10374[["y"]],
    c(0.94001, 0.97823, 0.11749, 0.475, 0.56033, 0.90403, 0.13871, 0.98889,
      0.94667, 0.08244, 0.51421, 0.3902, 0.90574, 0.44697, 0.836),
    tolerance = 1e-4)
  expect_equal(
    output_10374[[".shear_str"]],
    c("x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0", "x=1,y=0",
      "x=1,y=0", "x=1,y=0", "x=1,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(output_10374),
    c("x", "y", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(output_10374),
    c("numeric", "numeric", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(output_10374),
    c("double", "double", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(output_10374),
    c(15L, 4L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(output_10374)),
    character(0),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: overwrite = FALSE
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19735 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = FALSE), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error']]),
    xpectr::strip("Adding these dimensions would overwrite existing columns: x, y."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19735[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  # Testing shear_2d(data = df, x_shear = 1, y_shear = 0...
  # Changed from baseline: overwrite = NULL
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_14317 <- xpectr::capture_side_effects(shear_2d(data = df, x_shear = 1, y_shear = 0, x_col = "x", y_col = "y", suffix = "", origin = c(0, 0), origin_fn = NULL, keep_original = FALSE, shear_col_name = ".shear", origin_col_name = ".origin", overwrite = NULL), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error']]),
    xpectr::strip("Assertion on 'overwrite' failed: Must be of type 'logical flag', not 'NULL'."),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_14317[['error_class']]),
    xpectr::strip(c("simpleError", "error", "condition")),
    fixed = TRUE)

  ## Finished testing 'shear_2d'                                              ####
  #

})

test_that("testing expected output with shear_2d()", {
  xpectr::set_test_seed(42)

  df <- data.frame(
    "x" = c(1, 2, 3),
    "y" = c(11, 12, 13)
  )
  mat <- t(df)

  # Given x_shear ####

  # Expected (manual calculation)
  x_shear <- 3
  y_shear <- 0
  shearing_mat <- matrix(c(1, y_shear,
                           x_shear, 1),
                         nrow = 2)
  manually_sheared <- shearing_mat %*% mat

  # Rearrr version
  rearrr_sheared <- shear_2d(
    df,
    x_col = "x",
    y_col = "y",
    x_shear = x_shear,
    y_shear = y_shear,
    origin = c(0, 0)
  )

  # Check manual and rearrr shears are the same
  expect_equal(
    as.numeric(t(rearrr_sheared[, c("x_sheared", "y_sheared")])),
    as.numeric(manually_sheared)
  )


  ## Testing 'rearrr_sheared'                                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(rearrr_sheared),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    rearrr_sheared[["x"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["x_sheared"]],
    c(34, 38, 42),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y_sheared"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[[".shear_str"]],
    c("x=3,y=0", "x=3,y=0", "x=3,y=0"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(rearrr_sheared),
    c("x", "y", "x_sheared", "y_sheared", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(rearrr_sheared),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(rearrr_sheared),
    c("double", "double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(rearrr_sheared),
    c(3L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(rearrr_sheared)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'rearrr_sheared'                                      ####


  # Given y_shear ####

  # Expected (manual calculation)
  x_shear <- 0
  y_shear <- 3
  shearing_mat <- matrix(c(1, y_shear,
                           x_shear, 1),
                         nrow = 2)
  manually_sheared <- shearing_mat %*% mat

  # Rearrr version
  rearrr_sheared <- shear_2d(
    df,
    x_col = "x",
    y_col = "y",
    x_shear = x_shear,
    y_shear = y_shear,
    origin = c(0, 0)
  )

  # Check manual and rearrr shears are the same
  expect_equal(
    as.numeric(t(rearrr_sheared[, c("x_sheared", "y_sheared")])),
    as.numeric(manually_sheared)
  )


  ## Testing 'rearrr_sheared'                                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(rearrr_sheared),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    rearrr_sheared[["x"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["x_sheared"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y_sheared"]],
    c(14, 18, 22),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[[".shear_str"]],
    c("x=0,y=3", "x=0,y=3", "x=0,y=3"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(rearrr_sheared),
    c("x", "y", "x_sheared", "y_sheared", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(rearrr_sheared),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(rearrr_sheared),
    c("double", "double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(rearrr_sheared),
    c(3L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(rearrr_sheared)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'rearrr_sheared'                                      ####


  # Given x_shear and y_shear ####

  # Expected (manual calculation)
  x_shear <- 3
  y_shear <- 3
  shearing_mat <- matrix(c(1, y_shear,
                           x_shear, 1),
                         nrow = 2)
  manually_sheared <- shearing_mat %*% mat

  # Rearrr version
  rearrr_sheared <- shear_2d(
    df,
    x_col = "x",
    y_col = "y",
    x_shear = x_shear,
    y_shear = y_shear,
    origin = c(0, 0)
  )

  # Check manual and rearrr shears are the same
  expect_equal(
    as.numeric(t(rearrr_sheared[, c("x_sheared", "y_sheared")])),
    as.numeric(manually_sheared)
  )


  ## Testing 'rearrr_sheared'                                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing class
  expect_equal(
    class(rearrr_sheared),
    c("tbl_df", "tbl", "data.frame"),
    fixed = TRUE)
  # Testing column values
  expect_equal(
    rearrr_sheared[["x"]],
    c(1, 2, 3),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y"]],
    c(11, 12, 13),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["x_sheared"]],
    c(34, 38, 42),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[["y_sheared"]],
    c(14, 18, 22),
    tolerance = 1e-4)
  expect_equal(
    rearrr_sheared[[".shear_str"]],
    c("x=3,y=3", "x=3,y=3", "x=3,y=3"),
    fixed = TRUE)
  # Testing column names
  expect_equal(
    names(rearrr_sheared),
    c("x", "y", "x_sheared", "y_sheared", ".origin", ".shear", ".shear_str"),
    fixed = TRUE)
  # Testing column classes
  expect_equal(
    xpectr::element_classes(rearrr_sheared),
    c("numeric", "numeric", "numeric", "numeric", "list", "list", "character"),
    fixed = TRUE)
  # Testing column types
  expect_equal(
    xpectr::element_types(rearrr_sheared),
    c("double", "double", "double", "double", "list", "list", "character"),
    fixed = TRUE)
  # Testing dimensions
  expect_equal(
    dim(rearrr_sheared),
    c(3L, 7L))
  # Testing group keys
  expect_equal(
    colnames(dplyr::group_keys(rearrr_sheared)),
    character(0),
    fixed = TRUE)
  ## Finished testing 'rearrr_sheared'                                      ####



})
