% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pipeline.R
\name{Pipeline}
\alias{Pipeline}
\title{Chain multiple transformations}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

Build a pipeline of transformations to be applied sequentially.

Uses the same arguments for all groups in \code{`data`}.

Groupings are reset between each transformation. See \code{group_cols}.

\strong{Standard workflow}: Instantiate pipeline -> Add transformations -> Apply to data

To apply different argument values to each group, see
\code{\link[rearrr:GeneratedPipeline]{GeneratedPipeline}} for generating
argument values for an arbitrary number of groups and
\code{\link[rearrr:FixedGroupsPipeline]{FixedGroupsPipeline}} for specifying
specific values for a fixed set of groups.
}
\examples{
# Attach package
library(rearrr)

# Create a data frame
df <- data.frame(
  "Index" = 1:12,
  "A" = c(1:4, 9:12, 15:18),
  "G" = rep(1:3, each = 4)
)

# Create new pipeline
pipe <- Pipeline$new()

# Add 2D rotation transformation
# Note that we specify the grouping via `group_cols`
pipe$add_transformation(
  fn = rotate_2d,
  args = list(
    x_col = "Index",
    y_col = "A",
    origin = c(0, 0),
    degrees = 45,
    suffix = "",
    overwrite = TRUE
  ),
  name = "Rotate",
  group_cols = "G"
)

# Add the `cluster_group` transformation
# Note that this function requires the entire input data
# to properly scale the groups. We therefore specify `group_cols`
# as part of `args`. This works as `cluster_groups()` accepts that
# argument.
pipe$add_transformation(
  fn = cluster_groups,
  args = list(
    cols = c("Index", "A"),
    suffix = "",
    overwrite = TRUE,
    multiplier = 0.05,
    group_cols = "G"
  ),
  name = "Cluster"
)

# Check pipeline object
pipe

# Apply pipeline to data.frame
# Enable `verbose` to print progress
pipe$apply(df, verbose = TRUE)
}
\seealso{
Other pipelines: 
\code{\link{FixedGroupsPipeline}},
\code{\link{GeneratedPipeline}}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{pipelines}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{transformations}}{\code{list} of transformations to apply.}

\item{\code{names}}{Names of the transformations.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-add_transformation}{\code{Pipeline$add_transformation()}}
\item \href{#method-apply}{\code{Pipeline$apply()}}
\item \href{#method-print}{\code{Pipeline$print()}}
\item \href{#method-clone}{\code{Pipeline$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_transformation"></a>}}
\if{latex}{\out{\hypertarget{method-add_transformation}{}}}
\subsection{Method \code{add_transformation()}}{
Add a transformation to the pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$add_transformation(fn, args, name, group_cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fn}}{Function that performs the transformation.}

\item{\code{args}}{Named \code{list} with arguments for the \code{`fn`} function.}

\item{\code{name}}{Name of the transformation step. Must be unique.}

\item{\code{group_cols}}{Names of the columns to group the input
data by before applying the transformation.

Note that the transformation function is applied separately to each group (subset).
If the \code{`fn`} function requires access to the entire \code{data.frame}, the
grouping columns should be specified as part of \code{`args`} and
handled by the \code{`fn`} function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The pipeline. To allow chaining of methods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply"></a>}}
\if{latex}{\out{\hypertarget{method-apply}{}}}
\subsection{Method \code{apply()}}{
Apply the pipeline to a \code{data.frame}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$apply(data, verbose = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{\code{data.frame}.

A grouped \code{data.frame} will raise a warning and the grouping will be ignored.
Use the \code{`group_cols`} argument in the \code{`add_transformation`} method to
specify how \code{`data`} should be grouped for each transformation.}

\item{\code{verbose}}{Whether to print the progress.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Transformed version of \code{`data`}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print an overview of the pipeline.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{further arguments passed to or from other methods.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The pipeline. To allow chaining of methods.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Pipeline$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
