% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/alternation.R
\name{or}
\alias{\%|\%}
\alias{or}
\alias{or1}
\title{Alternation}
\usage{
or(..., capture = FALSE)

x \%|\% y

or1(x, capture = FALSE)
}
\arguments{
\item{...}{Character vectors.}

\item{capture}{A logical value indicating whether or not the result should be
captured.  See note.}

\item{x}{A character vector.}

\item{y}{A character vector.}
}
\value{
A character vector representing part or all of a regular expression.
}
\description{
Match one string or another.
}
\note{
\code{or} takes multiple character vector inputs and returns a
character vector of the inputs separated by pipes. \code{\%|\%} is an operator
interface to this function. \code{or1} takes a single character vector and
returns a string collapsed by pipes.

When \code{capture} is \code{TRUE}, the values are wrapped in a capture
group (see \code{\link{capture}}).  When \code{capture} is \code{FALSE} (the
default for \code{or} and \code{or1}), the values are wrapped in a
non-capture group (see \code{\link{token}}).  When \code{capture} is
\code{NA}, (the case for \code{\%|\%}) the values are not wrapped in
anything.
}
\examples{
or(letters, LETTERS, "foo")
letters \%|\% LETTERS \%|\% "foo"
or1(letters) # implicit non-capturing group
or1(letters, capture = TRUE)
or1(letters, capture = NA)
}
\references{
\url{http://www.regular-expressions.info/alternation.html}
}
\seealso{
\code{\link[base]{paste}}
}

