% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg_CD_global.R
\name{gg_CD_global}
\alias{gg_CD_global}
\title{Plots Cumulative Distributions of PIT-values for global calibration diagnose.}
\usage{
gg_CD_global(pit, ycal, yhat, mse)
}
\arguments{
\item{pit}{vector of global PIT-values}

\item{ycal}{vector of y calibration set}

\item{yhat}{vector of predicted y on calibration set}

\item{mse}{Mean Squared Error from calibration set}
}
\value{
a ggplot point graph
}
\description{
ggplot to visualize predicted vs empirical cumulative distributions of PIT-values.
}
\examples{

n <- 10000
split <- 0.8

# generating heterocedastic data
mu <- function(x1){
10 + 5*x1^2
}

sigma_v <- function(x1){
30*x1
}

x <- runif(n, 1, 10)
y <- rnorm(n, mu(x), sigma_v(x))

x_train <- x[1:(n*split)]
y_train <- y[1:(n*split)]

x_cal <- x[(n*split+1):n]
y_cal <- y[(n*split+1):n]

model <- lm(y_train ~ x_train)

y_hat <- predict(model, newdata=data.frame(x_train=x_cal))

MSE_cal <- mean((y_hat - y_cal)^2)

pit <- PIT_global( y_cal, y_hat,  MSE_cal)

gg_CD_global(pit,y_cal, y_hat, MSE_cal)


}
