% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/naindicate.R
\name{step_indicate_na}
\alias{step_indicate_na}
\alias{tidy.step_indicate_na}
\title{Create Missing Data Column Indicators}
\usage{
step_indicate_na(
  recipe,
  ...,
  role = "predictor",
  trained = FALSE,
  columns = NULL,
  prefix = "na_ind",
  skip = FALSE,
  id = rand_id("indicate_na")
)

\method{tidy}{step_indicate_na}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The check will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more details. For the \code{tidy}
method, these are not currently used.}

\item{role}{For model terms created by this step, what analysis
role should they be assigned?. By default, the function assumes
that the new na indicator columns created from the original
variables will be used as predictors in a model.}

\item{trained}{A logical for whether the selectors in \code{...}
have been resolved by \code{\link[=prep]{prep()}}.}

\item{columns}{A character string of variable names that will
be populated (eventually) by the terms argument.}

\item{prefix}{A character string that will be the prefix to the
resulting new variables. Defaults to "na_ind".}

\item{skip}{A logical. Should the check be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_indicate_na} object.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of existing steps (if any). For the \code{tidy} method, a tibble with
columns \code{terms} (the selectors or variables selected) and \code{model} (the
median value).
}
\description{
\code{step_indicate_na} creates a \emph{specification} of a recipe step that will
create and append additional binary columns to the dataset to indicate
which observations are missing.
}
\examples{
library(modeldata)
data("credit_data")

## missing data per column
purrr::map_dbl(credit_data, function(x) mean(is.na(x)))

set.seed(342)
in_training <- sample(1:nrow(credit_data), 2000)

credit_tr <- credit_data[ in_training, ]
credit_te <- credit_data[-in_training, ]

rec <- recipe(Price ~ ., data = credit_tr)

impute_rec <- rec \%>\%
  step_indicate_na(Income, Assets, Debt)

imp_models <- prep(impute_rec, training = credit_tr)

imputed_te <- bake(imp_models, new_data = credit_te, everything())
}
\concept{imputation}
\concept{preprocessing}
\keyword{datagen}
