% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.recurse.R
\name{plot.recurse}
\alias{plot.recurse}
\title{Calculates recursion information from the trajectory}
\usage{
\method{plot}{recurse}(x, xyt, ..., col, alpha = 1, legendPos = NULL)
}
\arguments{
\item{x}{\code{recurse} object returned from call to \code{\link{getRecursions}}}

\item{xyt}{data.frame of x, y, t, and id representing the xy-coordinates and the time (same as call to \code{\link{getRecursions}})}

\item{...}{additional arguments to \code{\link{plot}}}

\item{col}{optional vector of colors as long as the maximum number of revisits to color code trajectory points}

\item{alpha}{optional alpha value for color transparency between 0 and 1}

\item{legendPos}{a vector of length 2 with the x and y coordinate of the center of the legend in user coordinates}
}
\value{
the plot
}
\description{
Plots a trajectory color coded by number of revisits to each point.
}
\details{
This method allows the user to visually represent the number of revisitations by location. The size
of the circle of radius R can be added to the plot with \code{\link{drawCircle}}.
}
\examples{
data(martin)
revisits = getRecursions(martin, radius = 1)
plot(revisits, martin, legendPos = c(10, -15))
drawCircle(10, -10, 1)

}
\seealso{
\code{\link{getRecursions}}, \code{\link{getRecursionsAtLocations}}, \code{\link{drawCircle}}
}
\author{
Chloe Bracis <cbracis@uw.edu>
}
