% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/red.R
\name{countries}
\alias{countries}
\title{Countries of occurrence.}
\usage{
countries(spData, ISO = FALSE)
}
\arguments{
\item{spData}{Either a matrix of longitude and latitude (two columns) of each occurrence record or a presence/absence map as a RasterLayer object (must be in longlat units).}

\item{ISO}{Outputs either country names (FALSE) or ISO codes (TRUE).}
}
\value{
A vector with country names or codes.
}
\description{
Extracts the names or ISO codes of countries of occurrence of a species based on either records or predicted distribution.
}
\details{
Country boundaries and designations are based on data(worldborders) from package maptools.
}
\examples{
data(red.records)
data(red.distribution)
countries(red.records)
countries(red.distribution, ISO = TRUE)
}

