% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/registration.R
\name{register}
\alias{register}
\title{Registration parameter estimation}
\usage{
register(src, tar, method = "taylor", par0 = c(0, 0, 0), verbosity = 2,
  ...)
}
\arguments{
\item{src, tar}{cimg objects}

\item{method}{character indicating the method to be used}

\item{par0}{numeric vector for the initial guess for the registration parameters}

\item{verbosity}{Numeric indicating the level of verbosity is displayed}

\item{...}{parameters to be passed to the optimization algorithm}
}
\value{
the registration parameters, usually a 2d vector.
}
\description{
Registration parameter estimation
}
\examples{

src <- cameraman

tar <- shift(cameraman, c(5,-15))
round(s <- register(src, tar, method = 'coarse', steps = 4), 4)

tar <- shift(cameraman, c(-1.155, 3.231))
round(s <- register(src, tar, method = 'taylor', tol = 1e-4), 4)

tar <- transform(cameraman, c(c(-1.155, 1.231, 0.121)))
round(s <- register(src, tar, method = 'taylor3', tol = 1e-4, maxiter = 100), 4)
}
