% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/importToFileRepository.R
\name{importToFileRepository}
\alias{importToFileRepository}
\alias{importToFileRepository.redcapApiConnection}
\title{Import a Single File to the File Repository}
\usage{
importToFileRepository(rcon, file, folder_id = numeric(0), ...)

\method{importToFileRepository}{redcapApiConnection}(
  rcon,
  file,
  folder_id = numeric(0),
  ...,
  refresh = TRUE,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A redcap connection object.}

\item{file}{\code{character(1)} A file on the local system to be imported
to the File Repository.}

\item{folder_id}{\code{integerish(0/1)}. The ID of the folder into which 
the file is to be imported. If length is zero, it is imported to the 
top-level folder.}

\item{...}{Additional arguments to be passed between methods}

\item{refresh}{\code{logical(1)} When \code{TRUE} (default), the cached 
File Repository data on \code{rcon} will be refreshed.}

\item{error_handling}{An option for how to handle errors returned by the API.
see \code{\link{redcap_error}}}

\item{config}{\code{list} Additional configuration parameters to pass to 
\code{\link[httr]{POST}}. These are appended to any parameters in 
\code{rcon$config}.}

\item{api_param}{\code{list} Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\description{
This method allows you to import a single file into a 
  project's File Repository. The file may be stored in a specific folder 
  in the File Repository if a \code{folder_id} is provided.
}
\author{
Benjamin Nutter
}
