% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docsArmsMethods.R, R/exportArms.R,
%   R/importArms.R, R/deleteArms.R
\name{armsMethods}
\alias{armsMethods}
\alias{exportArms}
\alias{importArms}
\alias{deleteArms}
\alias{exportArms.redcapApiConnection}
\alias{importArms.redcapApiConnection}
\alias{deleteArms.redcapApiConnection}
\title{Export, Import, and Delete Arms from a Project}
\usage{
exportArms(rcon, ...)

importArms(rcon, data, override = FALSE, ...)

deleteArms(rcon, arms, ...)

\method{exportArms}{redcapApiConnection}(
  rcon,
  arms = character(0),
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{importArms}{redcapApiConnection}(
  rcon,
  data,
  override = FALSE,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)

\method{deleteArms}{redcapApiConnection}(
  rcon,
  arms,
  refresh = TRUE,
  ...,
  error_handling = getOption("redcap_error_handling"),
  config = list(),
  api_param = list()
)
}
\arguments{
\item{rcon}{A \code{redcapConnection} object.}

\item{arms}{\code{character} or \code{integerish} identifying the arm
numbers to export or delete.}

\item{data}{A \code{data.frame} with two columns.  The first column
(\code{arm_num}) is an \code{integerish} value . The second (\code{name}) is
a character value. For backward compatibility,
this may also be passed as \code{arms_data}.}

\item{override}{\code{logical(1)}. By default, data will add to or modify
existing arms data. When \code{TRUE}, all the existing arms data is
deleted and replaced with the contents of \code{data}.}

\item{refresh}{\code{logical(1)} If \code{TRUE}, the cached arms data will
be refreshed after the API action is complete.}

\item{...}{Arguments to pass to other methods}

\item{error_handling}{\code{character(1)}. One of \code{c("error", "null")}.
An option for how to handle errors returned by the API.
see \code{\link[=redcapError]{redcapError()}}.}

\item{config}{A named \code{list}. Additional configuration parameters to pass to
\code{\link[httr:POST]{httr::POST()}}. These are appended to any parameters in
\code{rcon$config}.}

\item{api_param}{A named \code{list}. Additional API parameters to pass into the
body of the API call. This provides users to execute calls with options
that may not otherwise be supported by \code{redcapAPI}.}
}
\value{
\code{exportArms} returns a \code{data.frame} with columns:\tabular{ll}{
    \tab  \cr
   \code{arm_num} \tab The ID number for the arm in the project. \cr
   \code{name} \tab The display name of the arm. \cr
}


\code{importArms} has no return and prints a message indicating the
number of arms imported.

\code{deleteArms} has no return and prints a message indicating the
number of arms deleted.
}
\description{
These methods enable the user to export the current arms
from a project, import new arms, and modify or delete existing arms.
}
\details{
Exporting arms is not supported for classical REDCap projects. If
the user attempts to export arms for a classical project, a
data frame will be returned with zero rows.

When importing, arms are added when the value of \code{arm_num}
does not already exist in the project.

Arm names may be modified by altering the \code{name} value associated
with an existing \code{arm_num} value.

Deleting arms--whether by \code{deleteArms} or \code{importArms} with
\code{override = TRUE}--is a destructive act that also deletes
events and records associated with the arm. This is irreversible
data loss. REDCap will only permit these actions to occur in projects
in Development status.
}
\section{Functions}{
\itemize{
\item \code{exportArms()}: Export the arms defined in a project.

\item \code{importArms()}: Import and modify the arms definitions in a project.

\item \code{deleteArms()}: Delete arms from a project.

}}
\examples{
\dontrun{
unlockREDCap(connections = c(rcon = "project_alias"), 
             url = "your_redcap_url", 
             keyring = "API_KEYs", 
             envir = globalenv())

# Export all of the Arms
exportArms(rcon)

# Export only a subset of arms
exportArms(rcon, 
           arms = c(1, 3))


# Import a new arms
# Assume arms 1, 2, and 3 exist in the project already
NewData <- data.frame(arm_num = 4, 
                      name = "Arm Four Name")
importArms(rcon, 
           data = NewData)
           
# Change the name of an existing arm
NewData <- data.frame(arm_num = 1, 
                      name = "New Arm Name")
importArms(rcon, 
           data = NewData)
           
# Delete all arms and replace with a new specification
NewData <- data.frame(arm_num = c(1, 2), 
                      name = c("Treatment Arm", "Control Arm"))
importArms(rcon, 
           data = NewData, 
           override = TRUE)
           
# Delete an existing arm
deleteArms(rcon, 
           arms = 4)
         
# Delete multiple existing arm
deleteArms(rcon, 
           arms = c(2, 3))
}
}
