% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enumpart.R
\name{redist.run.enumpart}
\alias{redist.run.enumpart}
\title{Runs the enumpart algorithm}
\usage{
redist.run.enumpart(
  ordered_path,
  out_path,
  ndists = 2,
  all = TRUE,
  n = NULL,
  weight_path = NULL,
  lower = NULL,
  upper = NULL,
  options = NULL,
  ndist
)
}
\arguments{
\item{ordered_path}{Path used in redist.prep.enumpart (not including ".dat")}

\item{out_path}{Valid path to output the enumerated districts}

\item{ndists}{number of districts to enumerate}

\item{all}{boolean. TRUE outputs all districts. FALSE samples n districts.}

\item{n}{integer. Number of districts to output if all is FALSE. Returns
districts selected from uniform random distribution.}

\item{weight_path}{A path (not including ".dat") to a space-delimited file containing a vector of
vertex weights, to be used along with \code{lower} and \code{upper}.}

\item{lower}{A lower bound on each partition's total weight, implemented by rejection sampling.}

\item{upper}{An upper bound on each partition's total weight.}

\item{options}{Additional enumpart arguments. Not recommended for use.}

\item{ndist}{Deprecated, use ndists. number of districts to enumerate}
}
\value{
0 on success
}
\description{
Runs the enumpart algorithm
}
\examples{
\dontrun{
temp <- tempdir()
redist.run.enumpart(ordered_path = paste0(temp, '/ordered'), 
out_path = paste0(temp, '/enumerated'))
}
}
\references{
Benjamin Fifield, Kosuke Imai, Jun Kawahara, and Christopher T Kenny.
"The Essential Role of Empirical Validation in Legislative Redistricting Simulation."
Forthcoming, Statistics and Public Policy.
}
\concept{enumerate}
